/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.xtriggerapi;

import hudson.console.HyperlinkNote;
import hudson.model.Cause;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import jenkins.security.MasterToSlaveCallable;
import org.apache.commons.io.FileUtils;
import org.jenkinsci.plugins.xtriggerapi.XTriggerCauseAction;
import org.jenkinsci.plugins.xtriggerapi.XTriggerException;

public class XTriggerCause
extends Cause
implements Serializable {
    private static final long serialVersionUID = -3551026356358107079L;
    private static Logger LOGGER = Logger.getLogger(XTriggerCause.class.getName());
    private String triggerName;
    private String causeFrom;
    private boolean logEnabled;

    protected XTriggerCause(String triggerName, String causeFrom) {
        this.triggerName = triggerName;
        this.causeFrom = causeFrom;
        this.logEnabled = false;
    }

    protected XTriggerCause(String triggerName, String causeFrom, boolean logEnabled) {
        this.triggerName = triggerName;
        this.causeFrom = causeFrom;
        this.logEnabled = logEnabled;
    }

    public void onAddedTo(final Run build) {
        final XTriggerCauseAction causeAction = (XTriggerCauseAction)build.getAction(XTriggerCauseAction.class);
        if (causeAction != null) {
            try {
                Jenkins.get().getRootPath().act((Callable)new MasterToSlaveCallable<Void, XTriggerException>(){

                    public Void call() throws XTriggerException {
                        causeAction.setBuild(build);
                        File triggerLogFile = causeAction.getLogFile();
                        String logContent = causeAction.getLogMessage();
                        try {
                            FileUtils.writeStringToFile((File)triggerLogFile, (String)logContent, (Charset)Charset.defaultCharset());
                        }
                        catch (IOException ioe) {
                            throw new XTriggerException(ioe);
                        }
                        return null;
                    }
                });
            }
            catch (IOException | InterruptedException | XTriggerException e) {
                LOGGER.log(Level.SEVERE, "Problem to attach cause object to build object.", e);
            }
        }
    }

    public String getShortDescription() {
        if (this.causeFrom == null) {
            return "[" + this.triggerName + "]";
        }
        if (!this.logEnabled) {
            return String.format("[%s] %s", this.triggerName, this.causeFrom);
        }
        return String.format("[%s] %s (%s)", this.triggerName, this.causeFrom, "<a href=\"triggerCauseAction\">log</a>");
    }

    public void print(TaskListener listener) {
        if (this.causeFrom == null) {
            listener.getLogger().println("[" + this.triggerName + "]");
        } else {
            listener.getLogger().printf("[%s] %s (%s)%n", this.triggerName, this.causeFrom, HyperlinkNote.encodeTo((String)"triggerCauseAction", (String)"log"));
        }
    }

    public String getTriggerName() {
        return this.triggerName;
    }
}

