/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugin.versioncolumn;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.Util;
import hudson.model.Computer;
import hudson.model.ComputerSet;
import hudson.model.Descriptor;
import hudson.node_monitors.AbstractAsyncNodeMonitorDescriptor;
import hudson.node_monitors.MonitorOfflineCause;
import hudson.node_monitors.NodeMonitor;
import hudson.plugin.versioncolumn.JVMVersionComparator;
import hudson.plugin.versioncolumn.Messages;
import hudson.remoting.Callable;
import hudson.slaves.OfflineCause;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.security.MasterToSlaveCallable;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.export.Exported;

public class JVMVersionMonitor
extends NodeMonitor {
    private static final Runtime.Version CONTROLLER_VERSION = Runtime.version();
    private static final Logger LOGGER = Logger.getLogger(JVMVersionMonitor.class.getName());
    private JVMVersionComparator.ComparisonMode comparisonMode = JVMVersionComparator.ComparisonMode.RUNTIME_GREATER_OR_EQUAL_MASTER_BYTECODE;
    private transient Boolean disconnect;

    @DataBoundConstructor
    public JVMVersionMonitor(JVMVersionComparator.ComparisonMode comparisonMode) {
        this.comparisonMode = comparisonMode;
    }

    public JVMVersionMonitor() {
    }

    public boolean isDisconnect() {
        return !this.isIgnored();
    }

    @DataBoundSetter
    public void setDisconnect(boolean disconnect) {
        this.setIgnored(!disconnect);
    }

    public Object readResolve() {
        if (this.disconnect != null) {
            this.setIgnored(this.disconnect == false);
        }
        return this;
    }

    public String toHtml(String version) {
        if (version == null || version.equals("N/A")) {
            return "N/A";
        }
        JVMVersionComparator jvmVersionComparator = new JVMVersionComparator(CONTROLLER_VERSION, Runtime.Version.parse(version), this.comparisonMode);
        if (jvmVersionComparator.isNotCompatible()) {
            return Util.wrapToErrorSpan((String)version);
        }
        return version;
    }

    public JVMVersionComparator.ComparisonMode getComparisonMode() {
        return this.comparisonMode;
    }

    private static class JavaVersion
    extends MasterToSlaveCallable<String, IOException> {
        private JavaVersion() {
        }

        public String call() {
            return Runtime.version().toString();
        }
    }

    public static class JVMMismatchCause
    extends MonitorOfflineCause {
        private final String message;

        public JVMMismatchCause(String message) {
            this.message = message;
        }

        @Exported(name="description")
        public String toString() {
            return this.message;
        }

        @NonNull
        public Class<? extends NodeMonitor> getTrigger() {
            return JVMVersionMonitor.class;
        }
    }

    @Extension
    @Symbol(value={"jvmVersion"})
    public static class JvmVersionDescriptor
    extends AbstractAsyncNodeMonitorDescriptor<String> {
        protected Map<Computer, String> monitor() throws InterruptedException {
            AbstractAsyncNodeMonitorDescriptor.Result base = this.monitorDetailed();
            Map data = base.getMonitoringData();
            JVMVersionMonitor monitor = (JVMVersionMonitor)ComputerSet.getMonitors().get((Descriptor)this);
            for (Map.Entry entry : data.entrySet()) {
                Computer computer = (Computer)entry.getKey();
                String version = (String)entry.getValue();
                if (base.getSkipped().contains(computer)) {
                    assert (version == null);
                    continue;
                }
                if (version == null) {
                    version = (String)this.get(computer);
                    entry.setValue(version);
                }
                this.markNodeOfflineOrOnline(computer, version, monitor);
            }
            return data;
        }

        private void markNodeOfflineOrOnline(Computer c, String agentVersionStr, JVMVersionMonitor monitor) {
            Runtime.Version agentVersion;
            if (agentVersionStr == null) {
                return;
            }
            try {
                agentVersion = Runtime.Version.parse(agentVersionStr);
            }
            catch (IllegalArgumentException e) {
                LOGGER.log(Level.WARNING, "Failed to parse agent version: " + agentVersionStr, e);
                return;
            }
            JVMVersionComparator jvmVersionComparator = new JVMVersionComparator(CONTROLLER_VERSION, agentVersion, monitor.comparisonMode);
            if (jvmVersionComparator.isNotCompatible()) {
                if (!this.isIgnored()) {
                    LOGGER.warning(Messages.JVMVersionMonitor_MarkedOffline(c.getName(), CONTROLLER_VERSION, agentVersionStr));
                    this.markOffline(c, (OfflineCause)new JVMMismatchCause(Messages.JVMVersionMonitor_OfflineCause()));
                } else {
                    LOGGER.finer("Version incompatibility detected, but keeping the agent '" + c.getName() + "' online per the node monitor configuration");
                    if (c.isOffline() && c.getOfflineCause() instanceof JVMMismatchCause) {
                        c.setTemporarilyOffline(false, null);
                    }
                }
            } else if (c.isOffline() && c.getOfflineCause() instanceof JVMMismatchCause) {
                c.setTemporarilyOffline(false, null);
            }
        }

        @NonNull
        public String getDisplayName() {
            return Messages.JVMVersionMonitor_DisplayName();
        }

        protected Callable<String, IOException> createCallable(Computer c) {
            return new JavaVersion();
        }

        public ListBoxModel doFillComparisonModeItems() {
            ListBoxModel items = new ListBoxModel();
            for (JVMVersionComparator.ComparisonMode goal : JVMVersionComparator.ComparisonMode.values()) {
                items.add(goal.getDescription(), goal.name());
            }
            return items;
        }
    }
}

