/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.todeclarative.converter.builder;

import hudson.Extension;
import hudson.model.FreeStyleProject;
import hudson.model.JDK;
import hudson.tasks.Maven;
import hudson.util.ArgumentListBuilder;
import io.jenkins.plugins.todeclarative.converter.api.ConverterRequest;
import io.jenkins.plugins.todeclarative.converter.api.ConverterResult;
import io.jenkins.plugins.todeclarative.converter.api.ModelASTUtils;
import io.jenkins.plugins.todeclarative.converter.api.SingleTypedConverter;
import io.jenkins.plugins.todeclarative.converter.builder.ShellConverter;
import java.util.Arrays;
import java.util.Map;
import jenkins.model.Jenkins;
import jenkins.mvn.FilePathGlobalSettingsProvider;
import jenkins.mvn.FilePathSettingsProvider;
import jenkins.mvn.GlobalSettingsProvider;
import jenkins.mvn.SettingsProvider;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTArgumentList;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTBranch;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTEnvironment;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTKey;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTPipelineDef;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTSingleArgument;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTStage;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTStep;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTValue;

@Extension(ordinal=100.0)
public class MavenConverter
extends SingleTypedConverter<Maven> {
    public static final String MAVEN_NUMBER_KEY = ShellConverter.class.getName() + ".shell.number";

    public boolean convert(ConverterRequest request, ConverterResult result, Object target) {
        GlobalSettingsProvider globalSettingsProvider;
        String settingsPath;
        SettingsProvider settingsProvider;
        FreeStyleProject freeStyleProject;
        JDK jdk;
        Maven maven = (Maven)target;
        Maven.MavenInstallation mavenInstallation = maven.getMaven();
        if (mavenInstallation != null) {
            ModelASTKey key = new ModelASTKey((Object)this);
            key.setKey("maven");
            ModelASTUtils.addTool((ModelASTPipelineDef)result.getModelASTPipelineDef(), (ModelASTKey)key, (ModelASTValue)ModelASTValue.fromConstant((Object)mavenInstallation.getName(), (Object)((Object)this)));
        }
        if (!((jdk = (freeStyleProject = (FreeStyleProject)request.getJob()).getJDK()) == null || Jenkins.get().getJDKs().size() == 1 && StringUtils.equalsIgnoreCase((String)"default", (String)jdk.getName()))) {
            ModelASTKey key = new ModelASTKey((Object)this);
            key.setKey("jdk");
            ModelASTUtils.addTool((ModelASTPipelineDef)result.getModelASTPipelineDef(), (ModelASTKey)key, (ModelASTValue)ModelASTValue.fromConstant((Object)jdk.getName(), (Object)((Object)this)));
        }
        ModelASTStage stage = new ModelASTStage((Object)this);
        int stageNumber = request.getAndIncrement(MAVEN_NUMBER_KEY);
        stage.setName("Maven Build " + stageNumber);
        ModelASTBranch branch = new ModelASTBranch((Object)this);
        stage.setBranches(Arrays.asList(branch));
        ModelASTStep step = new ModelASTStep((Object)this);
        branch.setSteps(Arrays.asList(step));
        ArgumentListBuilder args = new ArgumentListBuilder();
        args.add("mvn");
        Arrays.asList(StringUtils.split((String)maven.getTargets())).stream().forEach(s -> args.add(s));
        if (maven.usePrivateRepository) {
            args.add("-Dmaven.repo.local=.repository");
        }
        if (StringUtils.isNotBlank((String)maven.pom)) {
            args.add(new String[]{"-f", maven.pom});
        }
        if (StringUtils.isNotBlank((String)maven.properties)) {
            args.add(maven.properties);
        }
        if ((settingsProvider = maven.getSettings()) instanceof FilePathSettingsProvider && StringUtils.isNotBlank((String)(settingsPath = ((FilePathSettingsProvider)settingsProvider).getPath()))) {
            args.add(new String[]{"-s", settingsPath});
        }
        if ((globalSettingsProvider = maven.getGlobalSettings()) instanceof FilePathGlobalSettingsProvider && StringUtils.isNotBlank((String)(settingsPath = ((FilePathGlobalSettingsProvider)globalSettingsProvider).getPath()))) {
            args.add(new String[]{"-gs", settingsPath});
        }
        ModelASTSingleArgument singleArgument = new ModelASTSingleArgument((Object)this);
        singleArgument.setValue(ModelASTValue.fromConstant((Object)args.toString(), (Object)((Object)this)));
        step.setArgs((ModelASTArgumentList)singleArgument);
        step.setName("sh");
        if (StringUtils.isNotBlank((String)maven.jvmOptions)) {
            ModelASTEnvironment environment = stage.getEnvironment();
            if (environment == null) {
                environment = new ModelASTEnvironment((Object)this);
                stage.setEnvironment(environment);
            }
            Map environmentVariables = environment.getVariables();
            ModelASTKey key = new ModelASTKey((Object)this);
            key.setKey("MAVEN_OPTS");
            environmentVariables.put(key, ModelASTValue.fromConstant((Object)maven.jvmOptions, (Object)((Object)this)));
        }
        ModelASTUtils.addStage((ModelASTPipelineDef)result.getModelASTPipelineDef(), (ModelASTStage)stage);
        return true;
    }
}

