/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.testng;

import hudson.FilePath;
import hudson.model.Action;
import hudson.model.Api;
import hudson.model.Run;
import hudson.plugins.testng.Publisher;
import hudson.plugins.testng.TestNGProjectAction;
import hudson.plugins.testng.parser.ResultsParser;
import hudson.plugins.testng.results.MethodResult;
import hudson.plugins.testng.results.TestNGResult;
import hudson.tasks.junit.CaseResult;
import hudson.tasks.test.AbstractTestResultAction;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.tasks.SimpleBuildStep;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse2;

public class TestNGTestResultBuildAction
extends AbstractTestResultAction
implements Serializable,
SimpleBuildStep.LastBuildAction {
    private static final Logger LOGGER = Logger.getLogger(TestNGTestResultBuildAction.class.getName());
    private static final long serialVersionUID = 31415926L;
    private transient Reference<TestNGResult> testngResultRef;
    protected Integer passCount;
    protected int failCount;
    protected int skipCount;
    private final boolean escapeTestDescp;
    private final boolean escapeExceptionMsg;
    private final boolean showFailedBuilds;

    public TestNGTestResultBuildAction(TestNGResult testngResults, boolean escapeTestDescp, boolean escapeExceptionMsg, boolean showFailedBuilds) {
        if (testngResults != null) {
            this.testngResultRef = new WeakReference<TestNGResult>(testngResults);
            this.count(testngResults);
        }
        this.escapeTestDescp = escapeTestDescp;
        this.escapeExceptionMsg = escapeExceptionMsg;
        this.showFailedBuilds = showFailedBuilds;
    }

    private void count(TestNGResult testngResults) {
        this.passCount = testngResults.getPassCount();
        this.failCount = testngResults.getFailCount();
        this.skipCount = testngResults.getSkipCount();
    }

    private void countAndSave(TestNGResult testngResults) {
        int savedPassCount = this.passCount != null ? this.passCount : -1;
        int savedFailCount = this.failCount;
        int savedSkipCount = this.skipCount;
        this.count(testngResults);
        if (this.passCount != savedPassCount || this.failCount != savedFailCount || this.skipCount != savedSkipCount) {
            LOGGER.log(Level.FINE, "saving {0}", this.owner);
            try {
                this.owner.save();
            }
            catch (IOException x) {
                LOGGER.log(Level.WARNING, "failed to save " + String.valueOf(this.owner), x);
            }
        }
    }

    private void countAsNeeded() {
        if (this.passCount == null) {
            this.countAndSave(this.getResult());
        }
    }

    public TestNGResult getResult() {
        return this.getResult(this.run);
    }

    public TestNGResult getResult(Run build) {
        TestNGResult tr;
        TestNGResult testNGResult = tr = this.testngResultRef != null ? this.testngResultRef.get() : null;
        if (tr == null) {
            tr = TestNGTestResultBuildAction.loadResults(build, null);
            this.countAndSave(tr);
            this.testngResultRef = new WeakReference<TestNGResult>(tr);
        }
        return tr;
    }

    static TestNGResult loadResults(Run<?, ?> owner, PrintStream logger) {
        LOGGER.log(Level.FINE, "loading results for {0}", owner);
        FilePath testngDir = Publisher.getTestNGReport(owner);
        FilePath[] paths = null;
        try {
            paths = testngDir.list("testng-results*.xml");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (paths == null) {
            TestNGResult tr = new TestNGResult();
            tr.setRun(owner);
            return tr;
        }
        ResultsParser parser = new ResultsParser(logger);
        TestNGResult result = parser.parse(paths);
        result.setRun(owner);
        return result;
    }

    public String getIconFileName() {
        return "/plugin/testng-plugin/icons/report.png";
    }

    public int getFailCount() {
        this.countAsNeeded();
        return this.failCount;
    }

    public int getSkipCount() {
        this.countAsNeeded();
        return this.skipCount;
    }

    public int getTotalCount() {
        this.countAsNeeded();
        return this.failCount + this.passCount + this.skipCount;
    }

    public String getDisplayName() {
        return "TestNG Results";
    }

    public String getUrlName() {
        return "testngreports";
    }

    public Object getDynamic(String token, StaplerRequest2 req, StaplerResponse2 rsp) {
        return this.getResult().getDynamic(token, req, rsp);
    }

    public Api getApi() {
        return new Api((Object)this.getResult());
    }

    public List<CaseResult> getFailedTests() {
        ArrayList<CaseResult> results = new ArrayList<CaseResult>(this.getFailCount());
        for (MethodResult methodResult : this.getResult().getFailedTests()) {
            class HackyCaseResult
            extends CaseResult {
                private MethodResult methodResult;

                public HackyCaseResult(MethodResult methodResult) {
                    super(null, methodResult.getDisplayName(), methodResult.getErrorStackTrace());
                    this.methodResult = methodResult;
                }

                public CaseResult.Status getStatus() {
                    return CaseResult.Status.FAILED;
                }

                public String getClassName() {
                    return this.methodResult.getClassName();
                }

                public String getDisplayName() {
                    return this.methodResult.getDisplayName();
                }

                public String getErrorDetails() {
                    return this.methodResult.getErrorDetails();
                }

                public boolean equals(Object obj) {
                    return this == obj;
                }

                public int hashCode() {
                    return System.identityHashCode((Object)this);
                }
            }
            results.add(new HackyCaseResult(methodResult));
        }
        return results;
    }

    public Collection<? extends Action> getProjectActions() {
        return Collections.singleton(new TestNGProjectAction(this.run.getParent(), this.escapeTestDescp, this.escapeExceptionMsg, this.showFailedBuilds));
    }
}

