/*
 * Decompiled with CFR 0.152.
 */
package com.sysdig.jenkins.plugins.sysdig.infrastructure.json;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.sysdig.jenkins.plugins.sysdig.application.vm.report.PolicyEvaluationReport;
import com.sysdig.jenkins.plugins.sysdig.application.vm.report.PolicyEvaluationReportLine;
import java.lang.reflect.Type;
import java.util.List;
import java.util.stream.Stream;

public class PolicyEvaluationReportSerializer
implements JsonSerializer<PolicyEvaluationReport> {
    public JsonElement serialize(PolicyEvaluationReport policyEvaluationReport, Type type, JsonSerializationContext jsonSerializationContext) {
        JsonObject jsonObject = new JsonObject();
        policyEvaluationReport.getResultsForEachImage().forEach((key, value) -> jsonObject.add(key, this.serializeTopLevelResultsList(policyEvaluationReport, (List<PolicyEvaluationReportLine>)value)));
        return jsonObject;
    }

    private JsonElement serializeTopLevelResultsList(PolicyEvaluationReport policyEvaluationReport, List<PolicyEvaluationReportLine> results) {
        JsonObject resultObject = new JsonObject();
        resultObject.add("header", (JsonElement)this.header());
        resultObject.add("final_action", (JsonElement)new JsonPrimitive(policyEvaluationReport.isFailed() ? "STOP" : "GO"));
        resultObject.add("rows", (JsonElement)this.serializeRows(results));
        JsonObject jsonObject = new JsonObject();
        jsonObject.add("result", (JsonElement)resultObject);
        return jsonObject;
    }

    private JsonArray serializeRows(List<PolicyEvaluationReportLine> results) {
        JsonArray array = new JsonArray();
        results.stream().map(this::serializeRow).forEach(arg_0 -> ((JsonArray)array).add(arg_0));
        return array;
    }

    private JsonArray serializeRow(PolicyEvaluationReportLine result) {
        JsonArray array = new JsonArray();
        array.add(result.imageID());
        array.add(result.repoTag());
        array.add(result.triggerID());
        array.add(result.gate());
        array.add(result.trigger());
        array.add(result.checkOutput());
        array.add(result.gateAction());
        array.add(result.whitelisted());
        array.add(result.policyID());
        array.add(result.policyName());
        return array;
    }

    private JsonArray header() {
        JsonArray array = new JsonArray();
        Stream.of("Image_Id", "Repo_Tag", "Trigger_Id", "Gate", "Trigger", "Check_Output", "Gate_Action", "Whitelisted", "Policy_Id", "Policy_Name").forEach(arg_0 -> ((JsonArray)array).add(arg_0));
        return array;
    }
}

