/*
 * Decompiled with CFR 0.152.
 */
package com.sysdig.jenkins.plugins.sysdig.domain.vm.scanresult;

import com.sysdig.jenkins.plugins.sysdig.domain.AggregateChild;
import com.sysdig.jenkins.plugins.sysdig.domain.vm.scanresult.AcceptedRisk;
import com.sysdig.jenkins.plugins.sysdig.domain.vm.scanresult.Layer;
import com.sysdig.jenkins.plugins.sysdig.domain.vm.scanresult.Package;
import com.sysdig.jenkins.plugins.sysdig.domain.vm.scanresult.ScanResult;
import com.sysdig.jenkins.plugins.sysdig.domain.vm.scanresult.Severity;
import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class Vulnerability
implements AggregateChild<ScanResult>,
Serializable {
    private final String cve;
    private final Severity severity;
    private final Date disclosureDate;
    private final Date solutionDate;
    private final boolean exploitable;
    private final String fixVersion;
    private final Set<Package> foundInPackages;
    private final Set<AcceptedRisk> acceptedRisks;
    private final ScanResult root;

    Vulnerability(String cve, Severity severity, Date disclosureDate, Date solutionDate, boolean exploitable, @Nullable String fixVersion, ScanResult root) {
        this.cve = cve;
        this.severity = severity;
        this.disclosureDate = disclosureDate;
        this.solutionDate = solutionDate;
        this.exploitable = exploitable;
        this.fixVersion = fixVersion;
        this.foundInPackages = new HashSet<Package>();
        this.acceptedRisks = new HashSet<AcceptedRisk>();
        this.root = root;
    }

    public String cve() {
        return this.cve;
    }

    public Severity severity() {
        return this.severity;
    }

    public Date disclosureDate() {
        return this.disclosureDate;
    }

    public Optional<Date> solutionDate() {
        return Optional.ofNullable(this.solutionDate);
    }

    public boolean exploitable() {
        return this.exploitable;
    }

    public boolean fixable() {
        return this.fixVersion().isPresent();
    }

    public Optional<String> fixVersion() {
        return Optional.ofNullable(this.fixVersion);
    }

    public void addFoundInPackage(Package aPackage) {
        if (this.foundInPackages.add(aPackage)) {
            aPackage.addVulnerabilityFound(this);
        }
    }

    public Set<Package> foundInPackages() {
        return Collections.unmodifiableSet(this.foundInPackages);
    }

    public Set<Layer> foundInLayers() {
        return this.foundInPackages.stream().map(Package::foundInLayer).collect(Collectors.toUnmodifiableSet());
    }

    @Override
    public ScanResult root() {
        return this.root;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Vulnerability that = (Vulnerability)o;
        return Objects.equals(this.cve, that.cve);
    }

    public int hashCode() {
        return Objects.hashCode(this.cve);
    }

    public void addAcceptedRisk(AcceptedRisk acceptedRisk) {
        if (this.acceptedRisks.add(acceptedRisk)) {
            acceptedRisk.addForVulnerability(this);
        }
    }

    public Set<AcceptedRisk> acceptedRisks() {
        return Collections.unmodifiableSet(this.acceptedRisks);
    }
}

