/*
 * Decompiled with CFR 0.152.
 */
package com.sysdig.jenkins.plugins.sysdig.infrastructure.scanner;

import com.google.common.base.Strings;
import com.sysdig.jenkins.plugins.sysdig.infrastructure.scanner.SysdigProcessBuilderBase;
import java.util.ArrayList;
import java.util.List;

public class SysdigIaCScanningProcessBuilder
extends SysdigProcessBuilderBase<SysdigIaCScanningProcessBuilder> {
    private boolean isRecursive = false;
    private boolean listUnsupportedResources = false;
    private Severity severity = Severity.HIGH;
    private List<String> pathsToScan = new ArrayList<String>();

    public SysdigIaCScanningProcessBuilder(String sysdigCLIPath, String sysdigAPIToken) {
        super(sysdigCLIPath, sysdigAPIToken);
    }

    public SysdigIaCScanningProcessBuilder withRecursive(boolean isRecursive) {
        SysdigIaCScanningProcessBuilder clone = this.clone();
        clone.isRecursive = isRecursive;
        return clone;
    }

    public SysdigIaCScanningProcessBuilder withUnsupportedResources(boolean listUnsupportedResources) {
        SysdigIaCScanningProcessBuilder clone = this.clone();
        clone.listUnsupportedResources = listUnsupportedResources;
        return clone;
    }

    public SysdigIaCScanningProcessBuilder withSeverity(Severity severity) {
        SysdigIaCScanningProcessBuilder clone = this.clone();
        clone.severity = severity;
        return clone;
    }

    public SysdigIaCScanningProcessBuilder withPathsToScan(String ... pathListToScan) {
        SysdigIaCScanningProcessBuilder clone = this.clone();
        clone.pathsToScan.addAll(List.of(pathListToScan));
        return clone;
    }

    @Override
    public List<String> toCommandLineArguments() {
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add(this.sysdigCLIPath);
        arguments.add("--iac");
        if (!Strings.isNullOrEmpty((String)this.engineURL)) {
            arguments.add("--apiurl=" + this.engineURL);
        }
        if (this.consoleLogEnabled) {
            arguments.add("--console-log");
        }
        arguments.add("--loglevel=" + this.logLevel.toString());
        if (!Strings.isNullOrEmpty((String)this.scanResultOutputPath)) {
            arguments.add("--output-json=" + this.scanResultOutputPath);
        }
        if (!this.verifyTLS) {
            arguments.add("--skiptlsverify");
        }
        if (this.listUnsupportedResources) {
            arguments.add("--list-unsupported-resources");
        }
        this.policiesToApply.stream().map(policy -> "--policy=" + policy).forEach(arguments::add);
        if (this.isRecursive) {
            arguments.add("--recursive");
        }
        arguments.add("--severity-threshold=" + this.severity.toString());
        arguments.addAll(this.extraParams);
        arguments.addAll(!this.pathsToScan.isEmpty() ? this.pathsToScan : List.of("."));
        return arguments;
    }

    @Override
    public SysdigIaCScanningProcessBuilder clone() {
        SysdigIaCScanningProcessBuilder cloned = (SysdigIaCScanningProcessBuilder)super.clone();
        cloned.pathsToScan = new ArrayList<String>(this.pathsToScan);
        return cloned;
    }

    public static enum Severity {
        HIGH,
        MEDIUM,
        LOW,
        NEVER;


        public static Severity fromString(String severity) {
            return switch (severity.toLowerCase().trim()) {
                case "high", "h" -> HIGH;
                case "medium", "m" -> MEDIUM;
                case "low", "l" -> LOW;
                case "never", "n" -> NEVER;
                default -> throw new IllegalArgumentException("Unsupported severity: " + severity);
            };
        }

        public String toString() {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case HIGH -> "high";
                case MEDIUM -> "medium";
                case LOW -> "low";
                case NEVER -> "never";
            };
        }
    }
}

