/*
 * Decompiled with CFR 0.152.
 */
package com.sysdig.jenkins.plugins.sysdig.domain.vm.scanresult;

import com.sysdig.jenkins.plugins.sysdig.domain.AggregateChild;
import com.sysdig.jenkins.plugins.sysdig.domain.vm.scanresult.Package;
import com.sysdig.jenkins.plugins.sysdig.domain.vm.scanresult.ScanResult;
import com.sysdig.jenkins.plugins.sysdig.domain.vm.scanresult.Vulnerability;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class Layer
implements AggregateChild<ScanResult>,
Serializable {
    private final String digest;
    private final BigInteger size;
    private final String command;
    private final Set<Package> packages;
    private final ScanResult root;

    Layer(String digest, BigInteger size, String command, ScanResult root) {
        this.digest = digest;
        this.size = size;
        this.command = command;
        this.packages = new HashSet<Package>();
        this.root = root;
    }

    public Optional<String> digest() {
        if (this.digest == null || this.digest.isBlank()) {
            return Optional.empty();
        }
        return Optional.of(this.digest);
    }

    public Optional<BigInteger> size() {
        return Optional.ofNullable(this.size);
    }

    public String command() {
        return this.command;
    }

    @Override
    public ScanResult root() {
        return this.root;
    }

    void addPackage(Package aPackage) {
        this.packages.add(aPackage);
    }

    public Collection<Package> packages() {
        return Collections.unmodifiableCollection(this.packages);
    }

    public Collection<Vulnerability> vulnerabilities() {
        return this.packages().stream().flatMap(p -> p.vulnerabilities().stream()).collect(Collectors.toUnmodifiableSet());
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Layer layer = (Layer)o;
        return Objects.equals(this.digest, layer.digest);
    }

    public int hashCode() {
        return Objects.hashCode(this.digest);
    }
}

