/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.scanner.jenkins.pipeline;

import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import com.google.common.collect.ImmutableSet;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.AbortException;
import hudson.Extension;
import hudson.Util;
import hudson.model.Action;
import hudson.model.FreeStyleProject;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Queue;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.queue.Tasks;
import hudson.plugins.sonar.SonarInstallation;
import hudson.plugins.sonar.action.SonarAnalysisAction;
import hudson.plugins.sonar.client.HttpClient;
import hudson.plugins.sonar.client.OkHttpClientSingleton;
import hudson.plugins.sonar.client.ProjectInformation;
import hudson.plugins.sonar.client.WsClient;
import hudson.plugins.sonar.utils.SonarUtils;
import hudson.security.ACL;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.apache.commons.codec.digest.HmacAlgorithms;
import org.apache.commons.codec.digest.HmacUtils;
import org.jenkinsci.plugins.plaincredentials.StringCredentials;
import org.jenkinsci.plugins.scriptsecurity.sandbox.whitelists.Whitelisted;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.support.actions.PauseAction;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.sonarsource.scanner.jenkins.pipeline.SonarQubeWebHook;

public class WaitForQualityGateStep
extends Step
implements Serializable {
    private static final Logger LOGGER = Logger.getLogger(WaitForQualityGateStep.class.getName());
    private String taskId;
    private String installationName;
    private String serverUrl;
    private boolean abortPipeline;
    private String credentialsId;
    private String webhookSecretId;

    @DataBoundConstructor
    public WaitForQualityGateStep(boolean abortPipeline) {
        this.abortPipeline = abortPipeline;
    }

    @DataBoundSetter
    public void setWebhookSecretId(String webhookSecretId) {
        this.webhookSecretId = webhookSecretId;
    }

    public boolean isAbortPipeline() {
        return this.abortPipeline;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public void setInstallationName(String installationName) {
        this.installationName = installationName;
    }

    public void setServerUrl(String serverUrl) {
        this.serverUrl = serverUrl;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public String getInstallationName() {
        return this.installationName;
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    public String getCredentialsId() {
        return this.credentialsId;
    }

    public String getWebhookSecretId() {
        return this.webhookSecretId;
    }

    @DataBoundSetter
    public void setCredentialsId(@Nullable String credentialsId) {
        this.credentialsId = Util.fixEmpty((String)credentialsId);
    }

    public StepExecution start(StepContext context) throws Exception {
        return new Execution(this, context);
    }

    private static class Execution
    extends StepExecution
    implements Consumer<SonarQubeWebHook.WebhookEvent> {
        private static final String PLEASE_USE_THE_WITH_SONAR_QUBE_ENV_WRAPPER_TO_RUN_YOUR_ANALYSIS = "Please use the 'withSonarQubeEnv' wrapper to run your analysis.";
        private static final long serialVersionUID = 1L;
        private WaitForQualityGateStep step;
        String dashboardUrl;

        public Execution(WaitForQualityGateStep step, StepContext context) {
            super(context);
            this.step = step;
        }

        public boolean start() {
            this.processStepParameters();
            if (!this.checkTaskCompleted()) {
                SonarQubeWebHook.WebhookEvent webhookEvent = SonarQubeWebHook.get().getWebhookEventForTaskId(this.step.taskId);
                if (webhookEvent != null) {
                    this.validateWebhookAndCheckQualityGateIfValid(webhookEvent, true);
                    return true;
                }
                this.getContextClass(FlowNode.class).addAction((Action)new PauseAction("SonarQube analysis"));
                return false;
            }
            return true;
        }

        private void processStepParameters() {
            List actions = this.getContextClass(Run.class).getActions(SonarAnalysisAction.class);
            if (actions.isEmpty()) {
                throw new IllegalStateException("No previous SonarQube analysis found on this pipeline execution. Please use the 'withSonarQubeEnv' wrapper to run your analysis.");
            }
            String ceTaskId = null;
            String serverUrl = null;
            String installationName = null;
            String credentialsId = null;
            ArrayList reversedActions = new ArrayList(actions);
            Collections.reverse(reversedActions);
            for (SonarAnalysisAction a : reversedActions) {
                ceTaskId = a.getCeTaskId();
                if (ceTaskId == null) continue;
                serverUrl = a.getInstallationUrl();
                installationName = a.getInstallationName();
                this.dashboardUrl = a.getUrl();
                credentialsId = a.getCredentialsId();
                break;
            }
            if (ceTaskId == null || serverUrl == null || installationName == null) {
                throw new IllegalStateException("Unable to guess SonarQube task id and/or SQ server details. Please use the 'withSonarQubeEnv' wrapper to run your analysis.");
            }
            this.step.setTaskId(ceTaskId);
            this.step.setServerUrl(serverUrl);
            this.step.setInstallationName(installationName);
            this.step.setCredentialsId(credentialsId);
            if (this.step.webhookSecretId == null) {
                this.step.webhookSecretId = this.getInstallation().getWebhookSecretId();
            }
        }

        private void log(String msg, Object ... args) {
            this.getContextClass(TaskListener.class).getLogger().printf(msg, args);
            this.getContextClass(TaskListener.class).getLogger().println();
        }

        private boolean checkTaskCompleted() {
            SonarQubeWebHook.get().addListener(this);
            this.log("Checking status of SonarQube task '%s' on server '%s'", this.step.taskId, this.step.getInstallationName());
            SonarInstallation inst = this.getInstallation();
            WsClient wsClient = new WsClient(new HttpClient(OkHttpClientSingleton.getInstance()), this.step.getServerUrl(), SonarUtils.getAuthenticationToken(this.getContextClass(Run.class), inst, this.step.credentialsId));
            WsClient.CETask ceTask = wsClient.getCETask(this.step.getTaskId());
            ProjectInformation projectInformation = new ProjectInformation();
            projectInformation.setUrl(this.dashboardUrl);
            projectInformation.setCeStatus(ceTask.getStatus());
            projectInformation.setCeUrl(ceTask.getUrl());
            projectInformation.setName(ceTask.getComponentName());
            return this.checkQualityGate(projectInformation, () -> wsClient.requestQualityGateStatus(ceTask.getAnalysisId()), true);
        }

        private void handleQGStatus(ProjectInformation projectInformation) {
            this.getContextClass(Run.class).addAction((Action)projectInformation);
            String status = projectInformation.getStatus();
            if (this.step.isAbortPipeline() && !"OK".equals(status)) {
                this.getContext().onFailure((Throwable)new AbortException("Pipeline aborted due to quality gate failure: " + status));
            } else {
                this.getContext().onSuccess((Object)new QGStatus(status));
            }
        }

        public void onResume() {
            SonarQubeWebHook.get().addListener(this);
            try {
                this.checkTaskCompleted();
            }
            catch (Exception e) {
                throw new IllegalStateException("Unable to restore step", e);
            }
        }

        public void stop(Throwable cause) throws Exception {
            PauseAction.endCurrentPause((FlowNode)this.getContextClass(FlowNode.class));
            SonarQubeWebHook.get().removeListener(this);
            this.getContext().onFailure(cause);
        }

        @Override
        public void accept(SonarQubeWebHook.WebhookEvent event) {
            if (event.getPayload().getTaskId().equals(this.step.taskId)) {
                try {
                    PauseAction.endCurrentPause((FlowNode)this.getContextClass(FlowNode.class));
                    this.validateWebhookAndCheckQualityGateIfValid(event, false);
                }
                catch (IOException e) {
                    this.getContext().onFailure((Throwable)e);
                    throw new IllegalStateException(e);
                }
            }
        }

        private void validateWebhookAndCheckQualityGateIfValid(SonarQubeWebHook.WebhookEvent event, boolean onStart) {
            SonarQubeWebHook.get().removeListener(this);
            if (this.validateWebhook(event)) {
                ProjectInformation projectInformation = new ProjectInformation();
                SonarQubeWebHook.Payload payload = event.getPayload();
                projectInformation.setCeStatus(payload.getTaskStatus());
                projectInformation.setUrl(this.dashboardUrl);
                projectInformation.setName(payload.getComponentName());
                this.checkQualityGate(projectInformation, payload::getQualityGateStatus, onStart);
            }
        }

        private boolean checkQualityGate(ProjectInformation projectInformation, Supplier<String> qgStatusSupplier, boolean onStart) {
            String taskStatus = projectInformation.getCeStatus().toUpperCase(Locale.US);
            this.log("SonarQube task '%s' status is '%s'", this.step.taskId, taskStatus);
            switch (taskStatus) {
                case "SUCCESS": {
                    String qualityGateStatus = qgStatusSupplier.get();
                    projectInformation.setStatus(qualityGateStatus);
                    this.log("SonarQube task '%s' completed. Quality gate is '%s'", this.step.taskId, qualityGateStatus);
                    this.handleQGStatus(projectInformation);
                    return true;
                }
                case "FAILED": 
                case "CANCELED": {
                    IllegalStateException exception = new IllegalStateException("SonarQube analysis '" + this.step.getTaskId() + "' failed: " + taskStatus);
                    if (onStart) {
                        throw exception;
                    }
                    this.getContext().onFailure((Throwable)exception);
                    return true;
                }
            }
            if (onStart) {
                return false;
            }
            throw new IllegalStateException("Unexpected task status: " + taskStatus);
        }

        private boolean validateWebhook(SonarQubeWebHook.WebhookEvent event) {
            if (this.step.webhookSecretId != null && !this.step.webhookSecretId.isEmpty()) {
                StringCredentials webhookSecret = (StringCredentials)CredentialsProvider.findCredentialById((String)this.step.webhookSecretId, StringCredentials.class, (Run)this.getContextClass(Run.class));
                CredentialsProvider.track((Run)this.getContextClass(Run.class), (Credentials)webhookSecret);
                if (webhookSecret != null) {
                    boolean isValidPayload = Execution.isValidSignature(event.getReceivedSignature(), event.getPayload().getPayloadAsString(), webhookSecret.getSecret().getPlainText());
                    if (!isValidPayload) {
                        this.log("The incoming webhook didn't match the configured webhook secret", new Object[0]);
                        this.getContext().onFailure((Throwable)new AbortException("Pipeline aborted due to failed webhook verification "));
                    } else {
                        this.log("The incoming webhook matched the configured webhook secret", new Object[0]);
                    }
                    return isValidPayload;
                }
                this.log("A webhook secret id was configured, but the corresponding credential could not be found", new Object[0]);
                this.getContext().onFailure((Throwable)new AbortException("Pipeline aborted due to failed webhook verification"));
                return false;
            }
            return true;
        }

        private static boolean isValidSignature(String signature, String payload, String secret) {
            String expectedSignature = new HmacUtils(HmacAlgorithms.HMAC_SHA_256, secret).hmacHex(payload);
            return Objects.equals(expectedSignature, signature);
        }

        private SonarInstallation getInstallation() {
            return Optional.ofNullable(SonarInstallation.get(this.step.getInstallationName())).orElseThrow(() -> new IllegalStateException("Invalid installation name: " + this.step.getInstallationName()));
        }

        private <T> T getContextClass(Class<T> contextClass) {
            try {
                return (T)Optional.ofNullable(this.getContext().get(contextClass)).orElseThrow(() -> new IllegalStateException(String.format("Could not get %s from the Jenkins context", contextClass.getName())));
            }
            catch (IOException | IllegalStateException e) {
                this.getContext().onFailure((Throwable)e);
                throw new IllegalStateException(e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                this.getContext().onFailure((Throwable)e);
                throw new IllegalStateException(e);
            }
        }
    }

    @Extension(optional=true)
    public static final class DescriptorImpl
    extends StepDescriptor {
        @NonNull
        public String getDisplayName() {
            return "Wait for SonarQube analysis to be completed and return quality gate status";
        }

        public static ListBoxModel doFillCredentialsIdItems(@AncestorInPath @Nullable Item project, @QueryParameter String credentialsId) {
            if (project == null ? !Jenkins.get().hasPermission(Jenkins.ADMINISTER) : !project.hasPermission(Item.EXTENDED_READ)) {
                return new StandardListBoxModel().includeCurrentValue(credentialsId);
            }
            if (project == null) {
                project = new FreeStyleProject((ItemGroup)Jenkins.get(), "fake-" + String.valueOf(UUID.randomUUID()));
            }
            return new StandardListBoxModel().includeEmptyValue().includeMatchingAs(project instanceof Queue.Task ? Tasks.getAuthenticationOf((Queue.Task)((Queue.Task)project)) : ACL.SYSTEM, project, StringCredentials.class, Collections.emptyList(), CredentialsMatchers.always()).includeCurrentValue(credentialsId);
        }

        public static FormValidation doCheckCredentialsId(@AncestorInPath @Nullable Item project, @QueryParameter String value) {
            if (project == null ? !Jenkins.get().hasPermission(Jenkins.ADMINISTER) : !project.hasPermission(Item.EXTENDED_READ)) {
                return FormValidation.ok();
            }
            if ((value = Util.fixEmptyAndTrim((String)value)) == null) {
                return FormValidation.ok();
            }
            for (ListBoxModel.Option o : CredentialsProvider.listCredentials(StandardUsernameCredentials.class, (Item)project, (Authentication)(project instanceof Queue.Task ? Tasks.getAuthenticationOf((Queue.Task)((Queue.Task)project)) : ACL.SYSTEM), Collections.emptyList(), (CredentialsMatcher)CredentialsMatchers.always())) {
                if (!Objects.equals(value, o.value)) continue;
                return FormValidation.ok();
            }
            return FormValidation.warning((String)("Cannot find any credentials with id " + value));
        }

        public String getFunctionName() {
            return "waitForQualityGate";
        }

        public Set<Class<?>> getRequiredContext() {
            return ImmutableSet.of(FlowNode.class, Run.class, TaskListener.class);
        }
    }

    public static class QGStatus
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String status;

        public QGStatus(String status) {
            this.status = status;
        }

        @Whitelisted
        public String getStatus() {
            return this.status;
        }
    }
}

