/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sonar;

import com.google.common.annotations.VisibleForTesting;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.EnvVars;
import hudson.Extension;
import hudson.Launcher;
import hudson.Util;
import hudson.maven.MavenModuleSet;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.JDK;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.plugins.sonar.Messages;
import hudson.plugins.sonar.SonarInstallation;
import hudson.plugins.sonar.action.SonarMarkerAction;
import hudson.plugins.sonar.model.TriggersConfig;
import hudson.plugins.sonar.utils.Logger;
import hudson.plugins.sonar.utils.SonarMaven;
import hudson.plugins.sonar.utils.SonarUtils;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Maven;
import hudson.tasks.Notifier;
import hudson.tasks.Publisher;
import java.io.IOException;
import jenkins.model.Jenkins;
import jenkins.mvn.DefaultGlobalSettingsProvider;
import jenkins.mvn.DefaultSettingsProvider;
import jenkins.mvn.GlobalSettingsProvider;
import jenkins.mvn.SettingsProvider;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;

public class SonarPublisher
extends Notifier {
    private String jdk;
    private String installationName;
    private String branch;
    @Deprecated
    @VisibleForTesting
    transient String language;
    private final String mavenOpts;
    private String jobAdditionalProperties;
    private final TriggersConfig triggers;
    private final String mavenInstallationName;
    private final String rootPom;
    private final SettingsProvider settings;
    private final GlobalSettingsProvider globalSettings;
    private final boolean usePrivateRepository;

    @DataBoundConstructor
    public SonarPublisher(String installationName, String branch, TriggersConfig triggers, String jobAdditionalProperties, String mavenOpts, String mavenInstallationName, String rootPom, String jdk, @Nullable SettingsProvider settings, @Nullable GlobalSettingsProvider globalSettings, boolean usePrivateRepository) {
        this.installationName = installationName;
        this.branch = branch;
        this.jdk = StringUtils.trimToNull((String)jdk);
        this.triggers = triggers;
        this.mavenOpts = mavenOpts;
        this.jobAdditionalProperties = jobAdditionalProperties;
        this.mavenInstallationName = StringUtils.trimToNull((String)mavenInstallationName);
        this.rootPom = rootPom;
        this.settings = settings != null ? settings : new DefaultSettingsProvider();
        this.globalSettings = globalSettings != null ? globalSettings : new DefaultGlobalSettingsProvider();
        this.usePrivateRepository = usePrivateRepository;
    }

    public Object readResolve() {
        if (StringUtils.isNotBlank((String)this.language)) {
            StringBuilder sb = new StringBuilder();
            sb.append("-Dsonar.language=").append(this.language);
            if (StringUtils.isNotBlank((String)this.jobAdditionalProperties)) {
                sb.append(" ").append(this.jobAdditionalProperties);
            }
            this.jobAdditionalProperties = sb.toString();
        }
        return this;
    }

    public String getJdkName() {
        return this.jdk;
    }

    public void setJdkName(String jdk) {
        this.jdk = jdk;
    }

    private JDK getJDK() {
        return Jenkins.get().getJDK(this.jdk);
    }

    public String getInstallationName() {
        return this.installationName;
    }

    public void setInstallationName(String installationName) {
        this.installationName = installationName;
    }

    public String getMavenOpts() {
        return this.mavenOpts;
    }

    public String getJobAdditionalProperties() {
        return StringUtils.trimToEmpty((String)this.jobAdditionalProperties);
    }

    public void setJobAdditionalProperties(String jobAdditionalProperties) {
        this.jobAdditionalProperties = jobAdditionalProperties;
    }

    public boolean isUseGlobalTriggers() {
        return this.triggers == null;
    }

    public boolean isUseLocalTriggers() {
        return !this.isUseGlobalTriggers();
    }

    public String getBranch() {
        return this.branch;
    }

    public void setBranch(String branch) {
        this.branch = branch;
    }

    @Deprecated
    public String getLanguage() {
        return StringUtils.trimToEmpty((String)this.language);
    }

    public TriggersConfig getTriggers() {
        return this.triggers;
    }

    public String getMavenInstallationName() {
        return this.mavenInstallationName;
    }

    public String getRootPom() {
        return StringUtils.trimToEmpty((String)this.rootPom);
    }

    public static boolean isMavenBuilder(AbstractProject<?, ?> currentProject) {
        return currentProject instanceof MavenModuleSet;
    }

    public SonarInstallation getInstallation() {
        return SonarInstallation.get(this.getInstallationName());
    }

    private boolean isSkip(AbstractBuild<?, ?> build, BuildListener listener, SonarInstallation sonarInstallation) throws IOException, InterruptedException {
        String skipLaunchMsg = this.isUseGlobalTriggers() ? sonarInstallation.getTriggers().isSkipSonar(build, listener) : this.getTriggers().isSkipSonar(build, listener);
        if (skipLaunchMsg != null) {
            listener.getLogger().println(skipLaunchMsg);
            return true;
        }
        return false;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        if (!SonarInstallation.isValid(this.getInstallationName(), (TaskListener)listener)) {
            return false;
        }
        SonarInstallation sonarInstallation = this.getInstallation();
        if (this.isSkip(build, listener, sonarInstallation)) {
            SonarUtils.addBuildInfoFromLastBuildTo(build, (TaskListener)listener, sonarInstallation, true);
            return true;
        }
        boolean sonarSuccess = this.executeSonar(build, launcher, listener, sonarInstallation);
        if (!sonarSuccess) {
            build.setResult(Result.FAILURE);
        }
        SonarUtils.addBuildInfoTo(build, (TaskListener)listener, build.getWorkspace(), sonarInstallation);
        listener.getLogger().println("SonarQube analysis completed: " + String.valueOf(build.getResult()));
        return sonarSuccess;
    }

    public MavenModuleSet getMavenProject(AbstractBuild<?, ?> build) {
        return build.getProject() instanceof MavenModuleSet ? (MavenModuleSet)build.getProject() : null;
    }

    private String getPomName(AbstractBuild<?, ?> build, BuildListener listener) throws IOException, InterruptedException {
        String pomName;
        MavenModuleSet mavenModuleProject = this.getMavenProject(build);
        if (mavenModuleProject != null) {
            EnvVars envVars = build.getEnvironment((TaskListener)listener);
            pomName = mavenModuleProject.getRootPOM(envVars);
        } else {
            pomName = this.getRootPom();
        }
        if (StringUtils.isEmpty((String)pomName)) {
            pomName = "pom.xml";
        }
        return pomName;
    }

    private boolean executeSonar(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener, SonarInstallation sonarInstallation) {
        try {
            MavenModuleSet mavenModuleSet;
            String pomName = this.getPomName(build, listener);
            String mavenInstallName = this.getMavenInstallationName();
            if (SonarPublisher.isMavenBuilder(build.getProject()) && null != (mavenModuleSet = this.getMavenProject(build)).getMaven().getName()) {
                mavenInstallName = mavenModuleSet.getMaven().getName();
            }
            return SonarMaven.executeMaven(build, launcher, listener, mavenInstallName, pomName, sonarInstallation, this, this.getJDK(), this.getSettings(), this.getGlobalSettings(), this.usesPrivateRepository());
        }
        catch (IOException e) {
            Logger.printFailureMessage((TaskListener)listener);
            Util.displayIOException((IOException)e, (TaskListener)listener);
            Logger.LOG.throwing(((Object)((Object)this)).getClass().getName(), "setValues", e);
            e.printStackTrace(listener.fatalError("command execution failed"));
            return false;
        }
        catch (InterruptedException e) {
            Logger.LOG.throwing(((Object)((Object)this)).getClass().getName(), "executeSonar", e);
            return false;
        }
        catch (Exception e) {
            Logger.printFailureMessage((TaskListener)listener);
            e.printStackTrace(listener.fatalError("command execution failed"));
            Logger.LOG.throwing(((Object)((Object)this)).getClass().getName(), "executeSonar", e);
            return false;
        }
    }

    public Action getProjectAction(AbstractProject<?, ?> project) {
        return new SonarMarkerAction();
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.BUILD;
    }

    public SettingsProvider getSettings() {
        return this.settings != null ? this.settings : new DefaultSettingsProvider();
    }

    public GlobalSettingsProvider getGlobalSettings() {
        return this.globalSettings != null ? this.globalSettings : new DefaultGlobalSettingsProvider();
    }

    public boolean usesPrivateRepository() {
        return this.usePrivateRepository;
    }

    @Extension(ordinal=1000.0, optional=true)
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        private volatile SonarInstallation[] installations = new SonarInstallation[0];
        private volatile boolean buildWrapperEnabled = false;

        public DescriptorImpl() {
            this.load();
        }

        @NonNull
        public String getDisplayName() {
            return Messages.SonarPublisher_DisplayName();
        }

        @Deprecated
        public SonarInstallation[] getDeprecatedInstallations() {
            return this.installations;
        }

        @Deprecated
        public boolean isDeprecatedBuildWrapperEnabled() {
            return this.buildWrapperEnabled;
        }

        @Deprecated
        @VisibleForTesting
        void setDeprecatedInstallations(SonarInstallation[] installations) {
            this.installations = installations;
        }

        @Deprecated
        @VisibleForTesting
        void setDeprecatedBuildWrapperEnabled(boolean enabled) {
            this.buildWrapperEnabled = enabled;
        }

        public SonarInstallation[] getInstallations() {
            return SonarInstallation.all();
        }

        public String getHelpFile() {
            return "/plugin/sonar/help-sonar-publisher.html";
        }

        public String getHelpFile(String fieldName) {
            if ("globalSettings".equals(fieldName) || "settings".equals(fieldName)) {
                return ((Maven.DescriptorImpl)Jenkins.get().getDescriptorByType(Maven.DescriptorImpl.class)).getHelpFile("settings");
            }
            return super.getHelpFile(fieldName);
        }

        public void deleteGlobalConfiguration() {
            this.installations = null;
            this.buildWrapperEnabled = false;
            this.save();
        }

        public Maven.MavenInstallation[] getMavenInstallations() {
            return ((Maven.DescriptorImpl)Jenkins.get().getDescriptorByType(Maven.DescriptorImpl.class)).getInstallations();
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }
    }
}

