/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sonar;

import com.google.common.annotations.VisibleForTesting;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.EnvVars;
import hudson.Extension;
import hudson.Launcher;
import hudson.Util;
import hudson.model.EnvironmentSpecific;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.plugins.sonar.MsBuildSonarQubeRunnerInstaller;
import hudson.remoting.Callable;
import hudson.slaves.NodeSpecific;
import hudson.tools.ToolDescriptor;
import hudson.tools.ToolInstallation;
import hudson.tools.ToolInstaller;
import hudson.tools.ToolProperty;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import jenkins.security.MasterToSlaveCallable;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest2;

public class MsBuildSQRunnerInstallation
extends ToolInstallation
implements EnvironmentSpecific<MsBuildSQRunnerInstallation>,
NodeSpecific<MsBuildSQRunnerInstallation> {
    private static final long serialVersionUID = 1L;
    static final String SCANNER_EXE_NAME = "SonarScanner.MSBuild.exe";
    static final String SCANNER_DLL_NAME = "SonarScanner.MSBuild.dll";
    static final String OLD_SCANNER_EXE_NAME = "MSBuild.SonarQube.Runner.exe";
    private static String testExeName = null;

    @DataBoundConstructor
    public MsBuildSQRunnerInstallation(String name, @CheckForNull String home, List<? extends ToolProperty<?>> properties) {
        super(Util.fixEmptyAndTrim((String)name), Util.fixEmptyAndTrim((String)home), properties);
    }

    @VisibleForTesting
    static void setTestExeName(String exe) {
        testExeName = exe;
    }

    @VisibleForTesting
    static String getScannerToolPath(String home) {
        if (testExeName != null) {
            File testScanner = new File(home, testExeName);
            return testScanner.getPath();
        }
        File scannerNet46 = new File(home, SCANNER_EXE_NAME);
        if (scannerNet46.exists()) {
            return scannerNet46.getPath();
        }
        File scannerNetCore = new File(home, SCANNER_DLL_NAME);
        if (scannerNetCore.exists()) {
            return scannerNetCore.getPath();
        }
        File oldScanner = new File(home, OLD_SCANNER_EXE_NAME);
        if (oldScanner.exists()) {
            return oldScanner.getPath();
        }
        return null;
    }

    public MsBuildSQRunnerInstallation forEnvironment(EnvVars environment) {
        return new MsBuildSQRunnerInstallation(this.getName(), environment.expand(this.getHome()), this.getProperties().toList());
    }

    public MsBuildSQRunnerInstallation forNode(Node node, TaskListener log) throws IOException, InterruptedException {
        return new MsBuildSQRunnerInstallation(this.getName(), this.translateFor(node, log), this.getProperties().toList());
    }

    public static String getScannerName() {
        if (testExeName != null) {
            return testExeName;
        }
        return SCANNER_EXE_NAME;
    }

    public String getToolPath(Launcher launcher) throws IOException, InterruptedException {
        return (String)launcher.getChannel().call((Callable)new GetToolPath(this.getHome()));
    }

    private static class GetToolPath
    extends MasterToSlaveCallable<String, IOException> {
        private static final long serialVersionUID = 1L;
        private final String rawHome;

        GetToolPath(String rawHome) {
            this.rawHome = rawHome;
        }

        public String call() {
            String home = Util.replaceMacro((String)this.rawHome, (Map)EnvVars.masterEnvVars);
            return MsBuildSQRunnerInstallation.getScannerToolPath(home);
        }
    }

    @Extension
    public static class DescriptorImpl
    extends ToolDescriptor<MsBuildSQRunnerInstallation> {
        public DescriptorImpl() {
            this.load();
        }

        public void setInstallations(MsBuildSQRunnerInstallation ... installations) {
            super.setInstallations((ToolInstallation[])installations);
            this.save();
        }

        public MsBuildSQRunnerInstallation newInstance(StaplerRequest2 req, JSONObject formData) {
            return (MsBuildSQRunnerInstallation)((Object)req.bindJSON(this.clazz, formData));
        }

        @NonNull
        public String getDisplayName() {
            return "SonarScanner for MSBuild";
        }

        public List<? extends ToolInstaller> getDefaultInstallers() {
            return Collections.singletonList(new MsBuildSonarQubeRunnerInstaller(null));
        }
    }
}

