/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sonar;

import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.InvisibleAction;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.sonar.Messages;
import hudson.plugins.sonar.MsBuildSQRunnerInstallation;
import hudson.plugins.sonar.SonarInstallation;
import hudson.plugins.sonar.utils.BuilderUtils;
import hudson.tasks.Builder;
import hudson.util.ArgumentListBuilder;
import java.io.IOException;

public abstract class AbstractMsBuildSQRunner
extends Builder {
    static final String INST_NAME_KEY = "msBuildScannerInstallationName";
    static final String SONAR_INST_NAME_KEY = "sonarInstanceName";

    protected static SonarInstallation getSonarInstallation(String instName, TaskListener listener) throws AbortException {
        if (!SonarInstallation.isValid(instName, listener)) {
            throw new AbortException();
        }
        return SonarInstallation.get(instName);
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        FilePath workspace = build.getWorkspace();
        if (workspace == null) {
            throw new AbortException("no workspace for " + String.valueOf(build));
        }
        this.perform((Run<?, ?>)build, workspace, launcher, (TaskListener)listener);
        return true;
    }

    protected abstract void perform(Run<?, ?> var1, FilePath var2, Launcher var3, TaskListener var4) throws InterruptedException, IOException;

    protected String getScannerPath(MsBuildSQRunnerInstallation msBuildScanner, EnvVars env, Launcher launcher, TaskListener listener, FilePath workspace) throws IOException, InterruptedException {
        String exe;
        MsBuildSQRunnerInstallation inst = BuilderUtils.getBuildTool(msBuildScanner, env, listener, workspace);
        if (inst != null) {
            exe = inst.getToolPath(launcher);
            if (exe == null) {
                throw new AbortException(Messages.MsBuildScanner_ExecutableNotFound(inst.getName()));
            }
        } else {
            listener.getLogger().println(Messages.MsBuildScanner_NoInstallation());
            exe = MsBuildSQRunnerInstallation.getScannerName();
        }
        return exe;
    }

    protected void addDotNetCommand(ArgumentListBuilder args) {
        args.add("dotnet");
    }

    protected Boolean isDotNetCoreTool(String scannerPath) {
        return scannerPath.endsWith(".dll");
    }

    static class SonarQubeScannerMsBuildParams
    extends InvisibleAction {
        private final String scannerName;
        private final String sqServerName;

        SonarQubeScannerMsBuildParams(@Nullable String scannerName, @Nullable String sqServerName) {
            this.scannerName = Util.fixNull((String)scannerName);
            this.sqServerName = Util.fixNull((String)sqServerName);
        }

        public String getScannerName() {
            return this.scannerName;
        }

        public String getSqServerName() {
            return this.sqServerName;
        }
    }
}

