/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sonar.configurationslicing;

import configurationslicing.UnorderedStringSlicer;
import hudson.model.Project;
import hudson.plugins.sonar.SonarRunnerBuilder;
import hudson.plugins.sonar.utils.Logger;
import hudson.tasks.Builder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractSonarRunnerBuilderSlicerSpec
extends UnorderedStringSlicer.UnorderedStringSlicerSpec<Project<?, ?>> {
    protected abstract String getDefaultValue();

    public List<Project<?, ?>> getWorkDomain() {
        ArrayList workDomain = new ArrayList();
        for (Project item : Jenkins.get().getItems(Project.class)) {
            if (AbstractSonarRunnerBuilderSlicerSpec.getSonarRunnerBuilders(item).isEmpty()) continue;
            workDomain.add(item);
        }
        return workDomain;
    }

    public String getName(Project<?, ?> project) {
        return project.getFullName();
    }

    public String getDefaultValueString() {
        return this.getDefaultValue();
    }

    private static List<SonarRunnerBuilder> getSonarRunnerBuilders(Project<?, ?> project) {
        ArrayList<SonarRunnerBuilder> result = new ArrayList<SonarRunnerBuilder>();
        for (Builder builder : project.getBuilders()) {
            if (!(builder instanceof SonarRunnerBuilder)) continue;
            result.add((SonarRunnerBuilder)builder);
        }
        return result;
    }

    public final List<String> getValues(Project<?, ?> project) {
        ArrayList<String> values = new ArrayList<String>();
        values.add(this.doGetValue(AbstractSonarRunnerBuilderSlicerSpec.getSonarRunnerBuilders(project).get(0)));
        return values;
    }

    protected abstract String doGetValue(SonarRunnerBuilder var1);

    public final boolean setValues(Project<?, ?> project, List<String> list) {
        if (list.isEmpty()) {
            return false;
        }
        for (SonarRunnerBuilder builder : AbstractSonarRunnerBuilderSlicerSpec.getSonarRunnerBuilders(project)) {
            this.doSetValue(builder, list.iterator().next());
        }
        try {
            project.save();
        }
        catch (IOException e) {
            Logger.LOG.throwing(((Object)((Object)this)).getClass().getName(), "setValues", e);
            return false;
        }
        return true;
    }

    protected abstract void doSetValue(SonarRunnerBuilder var1, String var2);

    protected String defaultValueIfBlank(String value) {
        return StringUtils.isBlank((String)value) ? this.getDefaultValue() : value;
    }

    protected String nullIfDefaultValue(String value) {
        return this.getDefaultValue().equals(value) ? null : value;
    }
}

