/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.ready.jenkins;

import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Action;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.junit.TestResult;
import hudson.tasks.junit.TestResultAction;
import java.io.File;
import javax.annotation.Nonnull;

public class JUnitReportPublisher {
    private static final String JUNIT_REPORT_NAME = "report.xml";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean publish(@Nonnull Run<?, ?> run, TaskListener listener, @Nonnull Launcher launcher, String reportsFolderPath) {
        File junitReportTempFileOnMaster = new File(run.getRootDir().getAbsolutePath() + File.separator + JUNIT_REPORT_NAME);
        try {
            FilePath junitReportFileOnSlave = new FilePath(launcher.getChannel(), reportsFolderPath + JUNIT_REPORT_NAME);
            if (!junitReportFileOnSlave.exists()) {
                throw new Exception("Report file does not exist!");
            }
            new FilePath(junitReportTempFileOnMaster).copyFrom(junitReportFileOnSlave);
            Run<?, ?> run2 = run;
            synchronized (run2) {
                TestResultAction testResultAction = (TestResultAction)run.getAction(TestResultAction.class);
                boolean testResultActionExists = true;
                if (testResultAction == null) {
                    testResultActionExists = false;
                    TestResult testResult = new TestResult(true);
                    testResult.parse(junitReportTempFileOnMaster);
                    testResultAction = new TestResultAction(run, testResult, listener);
                } else {
                    TestResult testResult = testResultAction.getResult();
                    testResult.parse(junitReportTempFileOnMaster);
                    testResult.tally();
                    testResultAction.setResult(testResult, listener);
                }
                if (!testResultActionExists) {
                    run.addAction((Action)testResultAction);
                }
                listener.getLogger().println("JUnit-style report was published.");
            }
        }
        catch (Exception e) {
            e.printStackTrace(listener.getLogger());
            boolean bl = false;
            return bl;
        }
        finally {
            if (junitReportTempFileOnMaster.exists()) {
                junitReportTempFileOnMaster.delete();
            }
        }
        return true;
    }
}

