/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.rolestrategy.casc;

import com.michelin.cio.hudson.plugins.rolestrategy.PermissionEntry;
import com.michelin.cio.hudson.plugins.rolestrategy.PermissionTemplate;
import com.michelin.cio.hudson.plugins.rolestrategy.Role;
import com.michelin.cio.hudson.plugins.rolestrategy.RoleBasedAuthorizationStrategy;
import com.synopsys.arc.jenkins.plugins.rolestrategy.RoleType;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import io.jenkins.plugins.casc.Attribute;
import io.jenkins.plugins.casc.BaseConfigurator;
import io.jenkins.plugins.casc.ConfigurationContext;
import io.jenkins.plugins.casc.Configurator;
import io.jenkins.plugins.casc.ConfiguratorException;
import io.jenkins.plugins.casc.impl.attributes.MultivaluedAttribute;
import io.jenkins.plugins.casc.model.CNode;
import io.jenkins.plugins.casc.model.Mapping;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jenkinsci.plugins.rolestrategy.casc.GrantedRoles;
import org.jenkinsci.plugins.rolestrategy.casc.PermissionTemplateDefinition;
import org.jenkinsci.plugins.rolestrategy.casc.RoleDefinition;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Extension(optional=true, ordinal=2.0)
@Restricted(value={NoExternalUse.class})
public class RoleBasedAuthorizationStrategyConfigurator
extends BaseConfigurator<RoleBasedAuthorizationStrategy> {
    @NonNull
    public String getName() {
        return "roleStrategy";
    }

    public Class<RoleBasedAuthorizationStrategy> getTarget() {
        return RoleBasedAuthorizationStrategy.class;
    }

    @NonNull
    public Class getImplementedAPI() {
        return GrantedRoles.class;
    }

    protected RoleBasedAuthorizationStrategy instance(Mapping map, ConfigurationContext context) throws ConfiguratorException {
        Configurator c = context.lookupOrFail(GrantedRoles.class);
        GrantedRoles roles = (GrantedRoles)c.configure((CNode)map.remove((Object)"roles"), context);
        Set<PermissionTemplate> permissionTemplates = RoleBasedAuthorizationStrategyConfigurator.getPermissionTemplates(map, context);
        return new RoleBasedAuthorizationStrategy(roles.toMap(), permissionTemplates);
    }

    private static Set<PermissionTemplate> getPermissionTemplates(Mapping map, ConfigurationContext context) throws ConfiguratorException {
        Configurator c = context.lookupOrFail(PermissionTemplateDefinition.class);
        TreeSet<PermissionTemplate> permissionTemplates = new TreeSet<PermissionTemplate>();
        CNode sub = (CNode)map.remove((Object)"permissionTemplates");
        if (sub != null) {
            for (CNode o : sub.asSequence()) {
                PermissionTemplateDefinition template = (PermissionTemplateDefinition)c.configure(o, context);
                permissionTemplates.add(template.getPermissionTemplate());
            }
        }
        return permissionTemplates;
    }

    protected void configure(Mapping config, RoleBasedAuthorizationStrategy instance, boolean dryrun, ConfigurationContext context) throws ConfiguratorException {
        super.configure(config, (Object)instance, dryrun, context);
        if (!dryrun) {
            instance.validateConfig();
        }
    }

    @NonNull
    public Set<Attribute<RoleBasedAuthorizationStrategy, ?>> describe() {
        return new HashSet(Arrays.asList(new Attribute("roles", GrantedRoles.class).getter(target -> {
            SortedSet<RoleDefinition> globalRoles = this.getRoleDefinitions(target.getGrantedRolesEntries(RoleType.Global));
            SortedSet<RoleDefinition> agentRoles = this.getRoleDefinitions(target.getGrantedRolesEntries(RoleType.Slave));
            SortedSet<RoleDefinition> projectRoles = this.getRoleDefinitions(target.getGrantedRolesEntries(RoleType.Project));
            return new GrantedRoles(globalRoles, projectRoles, agentRoles);
        }), new MultivaluedAttribute("permissionTemplates", PermissionTemplateDefinition.class).getter(target -> this.getPermissionTemplateDefinitions(target.getPermissionTemplates()))));
    }

    @CheckForNull
    public CNode describe(RoleBasedAuthorizationStrategy instance, ConfigurationContext context) throws Exception {
        return this.compare((Object)instance, (Object)new RoleBasedAuthorizationStrategy(Collections.emptyMap()), context);
    }

    private Set<PermissionTemplateDefinition> getPermissionTemplateDefinitions(Set<PermissionTemplate> permissionTemplates) {
        if (permissionTemplates == null) {
            return Collections.emptySortedSet();
        }
        return new TreeSet<PermissionTemplateDefinition>(permissionTemplates.stream().map(RoleBasedAuthorizationStrategyConfigurator::getPermissionTemplateDefinition).collect(Collectors.toSet()));
    }

    private static PermissionTemplateDefinition getPermissionTemplateDefinition(PermissionTemplate permissionTemplate) {
        List<String> permissions = permissionTemplate.getPermissions().stream().map(permission -> permission.group.getId() + "/" + permission.name).collect(Collectors.toList());
        return new PermissionTemplateDefinition(permissionTemplate.getName(), permissions);
    }

    private SortedSet<RoleDefinition> getRoleDefinitions(@CheckForNull SortedMap<Role, Set<PermissionEntry>> roleMap) {
        if (roleMap == null) {
            return Collections.emptySortedSet();
        }
        return new TreeSet<RoleDefinition>(roleMap.entrySet().stream().map(this.getRoleDefinition()).collect(Collectors.toSet()));
    }

    private Function<Map.Entry<Role, Set<PermissionEntry>>, RoleDefinition> getRoleDefinition() {
        return roleSetEntry -> {
            Role role = (Role)roleSetEntry.getKey();
            List<String> permissions = role.getPermissions().stream().map(permission -> permission.group.title.toString(Locale.US) + "/" + permission.name).collect(Collectors.toList());
            Set<RoleDefinition.RoleDefinitionEntry> roleDefinitionEntries = ((Set)roleSetEntry.getValue()).stream().map(RoleDefinition.RoleDefinitionEntry::fromPermissionEntry).collect(Collectors.toSet());
            RoleDefinition roleDefinition = new RoleDefinition(role.getName(), role.getDescription(), role.getPattern().pattern(), permissions);
            roleDefinition.setEntries(roleDefinitionEntries);
            roleDefinition.setTemplateName(role.getTemplateName());
            return roleDefinition;
        };
    }
}

