/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.prometheus.collectors.disk;

import io.prometheus.client.Gauge;
import io.prometheus.client.SimpleCollector;
import java.io.IOException;
import java.nio.file.FileStore;
import org.jenkinsci.plugins.prometheus.collectors.BaseMetricCollector;
import org.jenkinsci.plugins.prometheus.collectors.CollectorType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileStoreCapacityGauge
extends BaseMetricCollector<FileStore, Gauge> {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileStoreCapacityGauge.class);

    protected FileStoreCapacityGauge(String[] labelNames, String namespace, String subsystem) {
        super(labelNames, namespace, subsystem);
    }

    @Override
    protected CollectorType getCollectorType() {
        return CollectorType.FILE_STORE_CAPACITY_GAUGE;
    }

    @Override
    protected String getHelpText() {
        return "Total size in bytes of the file stores used by Jenkins";
    }

    @Override
    protected SimpleCollector.Builder<?, Gauge> getCollectorBuilder() {
        return Gauge.build();
    }

    @Override
    public void calculateMetric(FileStore jenkinsObject, String[] labelValues) {
        if (jenkinsObject == null) {
            return;
        }
        try {
            ((Gauge.Child)((Gauge)this.collector).labels(labelValues)).set((double)jenkinsObject.getTotalSpace());
        }
        catch (IOException e) {
            LOGGER.debug("Failed to get total space of {}", (Object)jenkinsObject, (Object)e);
            ((Gauge.Child)((Gauge)this.collector).labels(labelValues)).set(Double.NaN);
        }
    }
}

