/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.prometheus.collectors.coverage;

import edu.hm.hafner.coverage.Coverage;
import edu.hm.hafner.coverage.Metric;
import hudson.model.Run;
import io.jenkins.plugins.coverage.metrics.model.Baseline;
import io.jenkins.plugins.coverage.metrics.steps.CoverageBuildAction;
import io.prometheus.client.SimpleCollector;
import java.util.Optional;
import org.jenkinsci.plugins.prometheus.collectors.builds.BuildsMetricCollector;

public abstract class CoverageMetricsCollector<T, I extends SimpleCollector<?>>
extends BuildsMetricCollector<T, I> {
    protected CoverageMetricsCollector(String[] labelNames, String namespace, String subsystem) {
        super(labelNames, namespace, subsystem);
    }

    protected Optional<Coverage> getCoverage(Run<?, ?> jenkinsRun, Metric metric, Baseline baseline) {
        CoverageBuildAction coverageBuildAction = (CoverageBuildAction)jenkinsRun.getAction(CoverageBuildAction.class);
        if (coverageBuildAction == null) {
            return Optional.empty();
        }
        return coverageBuildAction.getAllValues(baseline).stream().filter(value -> metric.equals((Object)value.getMetric()) && value instanceof Coverage).map(x -> (Coverage)x).findFirst();
    }

    protected double calculatePercentage(Coverage coverage) {
        if (coverage == null) {
            return -1.0;
        }
        long covered = coverage.getCovered();
        long total = coverage.getTotal();
        if (covered >= 0L && total >= 0L) {
            if (total != 0L) {
                return (double)(covered * 100L) / (double)total;
            }
            return -1.0;
        }
        return -1.0;
    }
}

