// CHECKSTYLE:OFF

package hudson.security.pam;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code PAMSecurityRealm.DisplayName}: {@code Unix user/group
     * database}.
     * 
     * @return
     *     {@code Unix user/group database}
     */
    public static String PAMSecurityRealm_DisplayName() {
        return holder.format("PAMSecurityRealm.DisplayName");
    }

    /**
     * Key {@code PAMSecurityRealm.DisplayName}: {@code Unix user/group
     * database}.
     * 
     * @return
     *     {@code Unix user/group database}
     */
    public static Localizable _PAMSecurityRealm_DisplayName() {
        return new Localizable(holder, "PAMSecurityRealm.DisplayName");
    }

    /**
     * Key {@code PAMSecurityRealm.User}: {@code User ‘{0}’}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code User ‘{0}’}
     */
    public static String PAMSecurityRealm_User(Object arg0) {
        return holder.format("PAMSecurityRealm.User", arg0);
    }

    /**
     * Key {@code PAMSecurityRealm.User}: {@code User ‘{0}’}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code User ‘{0}’}
     */
    public static Localizable _PAMSecurityRealm_User(Object arg0) {
        return new Localizable(holder, "PAMSecurityRealm.User", arg0);
    }

    /**
     * Key {@code PAMSecurityRealm.BelongToGroup}: {@code {0} needs to belong
     * to group {1} to read /etc/shadow}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code {0} needs to belong to group {1} to read /etc/shadow}
     */
    public static String PAMSecurityRealm_BelongToGroup(Object arg0, Object arg1) {
        return holder.format("PAMSecurityRealm.BelongToGroup", arg0, arg1);
    }

    /**
     * Key {@code PAMSecurityRealm.BelongToGroup}: {@code {0} needs to belong
     * to group {1} to read /etc/shadow}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code {0} needs to belong to group {1} to read /etc/shadow}
     */
    public static Localizable _PAMSecurityRealm_BelongToGroup(Object arg0, Object arg1) {
        return new Localizable(holder, "PAMSecurityRealm.BelongToGroup", arg0, arg1);
    }

    /**
     * Key {@code PAMSecurityRealm.RunAsUserOrBelongToGroupAndChmod}: {@code
     * Either Jenkins needs to run as {0} or {1} needs to belong to group {2}
     * and ‘chmod g+r /etc/shadow’ needs to be done to enable Jenkins to read
     * /etc/shadow}.
     * 
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Either Jenkins needs to run as {0} or {1} needs to belong to
     *     group {2} and ‘chmod g+r /etc/shadow’ needs to be done to enable
     *     Jenkins to read /etc/shadow}
     */
    public static String PAMSecurityRealm_RunAsUserOrBelongToGroupAndChmod(Object arg0, Object arg1, Object arg2) {
        return holder.format("PAMSecurityRealm.RunAsUserOrBelongToGroupAndChmod", arg0, arg1, arg2);
    }

    /**
     * Key {@code PAMSecurityRealm.RunAsUserOrBelongToGroupAndChmod}: {@code
     * Either Jenkins needs to run as {0} or {1} needs to belong to group {2}
     * and ‘chmod g+r /etc/shadow’ needs to be done to enable Jenkins to read
     * /etc/shadow}.
     * 
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Either Jenkins needs to run as {0} or {1} needs to belong to
     *     group {2} and ‘chmod g+r /etc/shadow’ needs to be done to enable
     *     Jenkins to read /etc/shadow}
     */
    public static Localizable _PAMSecurityRealm_RunAsUserOrBelongToGroupAndChmod(Object arg0, Object arg1, Object arg2) {
        return new Localizable(holder, "PAMSecurityRealm.RunAsUserOrBelongToGroupAndChmod", arg0, arg1, arg2);
    }

    /**
     * Key {@code PAMSecurityRealm.CurrentUser}: {@code Current User}.
     * 
     * @return
     *     {@code Current User}
     */
    public static String PAMSecurityRealm_CurrentUser() {
        return holder.format("PAMSecurityRealm.CurrentUser");
    }

    /**
     * Key {@code PAMSecurityRealm.CurrentUser}: {@code Current User}.
     * 
     * @return
     *     {@code Current User}
     */
    public static Localizable _PAMSecurityRealm_CurrentUser() {
        return new Localizable(holder, "PAMSecurityRealm.CurrentUser");
    }

    /**
     * Key {@code PAMSecurityRealm.UnsupportedOperation}: {@code It is not
     * possible to retrieve the file attributes for `/etc/shadow` file and so
     * it is impossible to test the configuration }.
     * 
     * @return
     *     {@code It is not possible to retrieve the file attributes for
     *     `/etc/shadow` file and so it is impossible to test the configuration }
     */
    public static String PAMSecurityRealm_UnsupportedOperation() {
        return holder.format("PAMSecurityRealm.UnsupportedOperation");
    }

    /**
     * Key {@code PAMSecurityRealm.UnsupportedOperation}: {@code It is not
     * possible to retrieve the file attributes for `/etc/shadow` file and so
     * it is impossible to test the configuration }.
     * 
     * @return
     *     {@code It is not possible to retrieve the file attributes for
     *     `/etc/shadow` file and so it is impossible to test the configuration }
     */
    public static Localizable _PAMSecurityRealm_UnsupportedOperation() {
        return new Localizable(holder, "PAMSecurityRealm.UnsupportedOperation");
    }

    /**
     * Key {@code PAMSecurityRealm.Success}: {@code Success}.
     * 
     * @return
     *     {@code Success}
     */
    public static String PAMSecurityRealm_Success() {
        return holder.format("PAMSecurityRealm.Success");
    }

    /**
     * Key {@code PAMSecurityRealm.Success}: {@code Success}.
     * 
     * @return
     *     {@code Success}
     */
    public static Localizable _PAMSecurityRealm_Success() {
        return new Localizable(holder, "PAMSecurityRealm.Success");
    }

    /**
     * Key {@code PAMSecurityRealm.ReadPermission}: {@code Jenkins needs to
     * be able to read /etc/shadow}.
     * 
     * @return
     *     {@code Jenkins needs to be able to read /etc/shadow}
     */
    public static String PAMSecurityRealm_ReadPermission() {
        return holder.format("PAMSecurityRealm.ReadPermission");
    }

    /**
     * Key {@code PAMSecurityRealm.ReadPermission}: {@code Jenkins needs to
     * be able to read /etc/shadow}.
     * 
     * @return
     *     {@code Jenkins needs to be able to read /etc/shadow}
     */
    public static Localizable _PAMSecurityRealm_ReadPermission() {
        return new Localizable(holder, "PAMSecurityRealm.ReadPermission");
    }

    /**
     * Key {@code PAMSecurityRealm.Uid}: {@code uid: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code uid: {0}}
     */
    public static String PAMSecurityRealm_Uid(Object arg0) {
        return holder.format("PAMSecurityRealm.Uid", arg0);
    }

    /**
     * Key {@code PAMSecurityRealm.Uid}: {@code uid: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code uid: {0}}
     */
    public static Localizable _PAMSecurityRealm_Uid(Object arg0) {
        return new Localizable(holder, "PAMSecurityRealm.Uid", arg0);
    }

}
