// CHECKSTYLE:OFF

package hudson.plugins.openid;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code OpenIdLoginService.SessionNotFound}: {@code Unable to find
     * an on-going OpenID session. Could it be that you have multiple host
     * names for your Jenkins and you started the authentication in one host
     * name and landed back on another? If so configure the correct Jenkins
     * root URL so that those two host names will be the same}.
     * 
     * @return
     *     {@code Unable to find an on-going OpenID session. Could it be that you
     *     have multiple host names for your Jenkins and you started the
     *     authentication in one host name and landed back on another? If so
     *     configure the correct Jenkins root URL so that those two host names
     *     will be the same}
     */
    public static String OpenIdLoginService_SessionNotFound() {
        return holder.format("OpenIdLoginService.SessionNotFound");
    }

    /**
     * Key {@code OpenIdLoginService.SessionNotFound}: {@code Unable to find
     * an on-going OpenID session. Could it be that you have multiple host
     * names for your Jenkins and you started the authentication in one host
     * name and landed back on another? If so configure the correct Jenkins
     * root URL so that those two host names will be the same}.
     * 
     * @return
     *     {@code Unable to find an on-going OpenID session. Could it be that you
     *     have multiple host names for your Jenkins and you started the
     *     authentication in one host name and landed back on another? If so
     *     configure the correct Jenkins root URL so that those two host names
     *     will be the same}
     */
    public static Localizable _OpenIdLoginService_SessionNotFound() {
        return new Localizable(holder, "OpenIdLoginService.SessionNotFound");
    }

}
