/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.nodejs.tools;

import hudson.model.DownloadService;
import hudson.model.Node;
import hudson.tools.DownloadFromUrlInstaller;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import jenkins.plugins.nodejs.Messages;
import jenkins.plugins.nodejs.tools.CPU;
import jenkins.plugins.nodejs.tools.DetectionFailedException;
import jenkins.plugins.nodejs.tools.InstallableComparator;
import jenkins.plugins.nodejs.tools.InstallerPathResolver;
import jenkins.plugins.nodejs.tools.Platform;
import net.sf.json.JSONObject;

class ToolsUtils {
    private ToolsUtils() {
    }

    public static Platform getPlatform(Node node) throws DetectionFailedException {
        return Platform.of(node);
    }

    public static CPU getCPU(Node node) throws DetectionFailedException {
        return ToolsUtils.getCPU(node, false);
    }

    public static CPU getCPU(Node node, boolean force32bit) throws DetectionFailedException {
        CPU nodeCPU = CPU.of(node);
        if (force32bit) {
            if (!ToolsUtils.support32Bit(nodeCPU)) {
                throw new DetectionFailedException(Messages.SystemTools_unsupported32bitArchitecture());
            }
            if (nodeCPU == CPU.amd64) {
                nodeCPU = CPU.i386;
            }
        }
        return nodeCPU;
    }

    private static boolean support32Bit(CPU cpu) {
        switch (cpu) {
            case armv6l: 
            case armv7l: 
            case i386: 
            case amd64: {
                return true;
            }
        }
        return false;
    }

    public static List<? extends DownloadFromUrlInstaller.Installable> getInstallable() throws IOException {
        JSONObject d;
        List installables = Collections.emptyList();
        DownloadService.Downloadable downloadable = DownloadService.Downloadable.get((String)"hudson.plugins.nodejs.tools.NodeJSInstaller");
        if (downloadable != null && (d = downloadable.getData()) != null) {
            installables = Arrays.asList(((DownloadFromUrlInstaller.InstallableList)JSONObject.toBean((JSONObject)d, DownloadFromUrlInstaller.InstallableList.class)).list).stream().filter(i -> !InstallerPathResolver.Factory.isVersionBlacklisted(i.id)).sorted(new InstallableComparator()).collect(Collectors.toList());
        }
        return installables;
    }
}

