/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.nodejs.configfiles;

import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.common.UsernamePasswordCredentials;
import com.cloudbees.plugins.credentials.domains.URIRequirementBuilder;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.Util;
import hudson.model.Run;
import hudson.util.Secret;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jenkins.plugins.nodejs.configfiles.NPMRegistry;
import jenkins.plugins.nodejs.configfiles.Npmrc;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.plaincredentials.StringCredentials;

public final class RegistryHelper {
    private final Collection<NPMRegistry> registries;

    public RegistryHelper(@CheckForNull Collection<NPMRegistry> registries) {
        this.registries = registries;
    }

    public Map<String, StandardCredentials> resolveCredentials(Run<?, ?> build) {
        HashMap<String, StandardCredentials> registry2credential = new HashMap<String, StandardCredentials>();
        for (NPMRegistry registry : this.registries) {
            StandardCredentials c;
            String credentialsId = registry.getCredentialsId();
            if (credentialsId == null) continue;
            URL registryURL = RegistryHelper.toURL(registry.getUrl());
            List domainRequirements = Collections.emptyList();
            if (registryURL != null) {
                domainRequirements = URIRequirementBuilder.fromUri((String)registry.getUrl()).build();
            }
            if ((c = (StandardCredentials)CredentialsProvider.findCredentialById((String)credentialsId, StandardCredentials.class, build, (List)domainRequirements)) == null) continue;
            registry2credential.put(registry.getUrl(), c);
        }
        return registry2credential;
    }

    public String fillRegistry(String npmrcContent, Map<String, StandardCredentials> registry2Credentials) {
        return this.fillRegistry(npmrcContent, registry2Credentials, false);
    }

    public String fillRegistry(String npmrcContent, Map<String, StandardCredentials> registry2Credentials, boolean npm9Format) {
        Npmrc npmrc = new Npmrc();
        npmrc.from(npmrcContent);
        for (NPMRegistry registry : this.registries) {
            StandardCredentials credentials = null;
            if (registry2Credentials.containsKey(registry.getUrl())) {
                credentials = registry2Credentials.get(registry.getUrl());
            }
            if (registry.isHasScopes()) {
                for (String scope : registry.getScopesAsList()) {
                    String registryPrefix = this.calculatePrefix(registry.getUrl());
                    String registryURL = this.fixURL(registry.getUrl());
                    npmrc.set(this.compose("@" + scope, "registry"), registryURL);
                    if (credentials == null) continue;
                    npmrc.set(this.compose(registryPrefix, "always-auth"), credentials != null);
                    if (credentials instanceof UsernamePasswordCredentials) {
                        UsernamePasswordCredentials usernamePassowrd = (UsernamePasswordCredentials)credentials;
                        String passwordValue = Base64.encodeBase64String((byte[])Secret.toString((Secret)usernamePassowrd.getPassword()).getBytes(StandardCharsets.UTF_8));
                        npmrc.set(this.compose(registryPrefix, "username"), usernamePassowrd.getUsername());
                        npmrc.set(this.compose(registryPrefix, "_password"), passwordValue);
                        continue;
                    }
                    if (!(credentials instanceof StringCredentials)) continue;
                    StringCredentials stringCredentials = (StringCredentials)credentials;
                    String tokenValue = Secret.toString((Secret)stringCredentials.getSecret());
                    npmrc.set(this.compose(registryPrefix, "_authToken"), tokenValue);
                }
                continue;
            }
            String registryPrefix = npm9Format ? this.calculatePrefix(registry.getUrl()) : null;
            npmrc.set("registry", registry.getUrl());
            if (credentials == null) continue;
            npmrc.set(this.compose(registryPrefix, "always-auth"), credentials != null);
            if (credentials instanceof UsernamePasswordCredentials) {
                UsernamePasswordCredentials usernamePassowrd = (UsernamePasswordCredentials)credentials;
                Object authValue = usernamePassowrd.getUsername() + ":" + Secret.toString((Secret)usernamePassowrd.getPassword());
                authValue = Base64.encodeBase64String((byte[])((String)authValue).getBytes(StandardCharsets.UTF_8));
                npmrc.set(this.compose(registryPrefix, "_auth"), (String)authValue);
                continue;
            }
            if (!(credentials instanceof StringCredentials)) continue;
            StringCredentials stringCredentials = (StringCredentials)credentials;
            String tokenValue = Secret.toString((Secret)stringCredentials.getSecret());
            npmrc.set(this.compose(registryPrefix, "_authToken"), tokenValue);
        }
        return npmrc.toString();
    }

    @NonNull
    private String fixURL(@NonNull String registryURL) {
        Object url = registryURL;
        if (!((String)url).endsWith("/")) {
            url = (String)url + "/";
        }
        return url;
    }

    @NonNull
    public String calculatePrefix(@NonNull String registryURL) {
        String trimmedURL = this.trimSlash(registryURL);
        URL url = RegistryHelper.toURL(trimmedURL);
        if (url == null) {
            throw new IllegalArgumentException("Invalid url " + registryURL);
        }
        return "//" + trimmedURL.substring((url.getProtocol() + "://").length()) + "/";
    }

    @NonNull
    public String compose(@NonNull String registryPrefix, @NonNull String setting) {
        if (StringUtils.isBlank((String)registryPrefix)) {
            return setting;
        }
        return registryPrefix + ":" + setting;
    }

    @NonNull
    private String trimSlash(@NonNull String url) {
        if (url != null && url.endsWith("/")) {
            return url.substring(0, url.length() - 1);
        }
        return url;
    }

    @CheckForNull
    private static URL toURL(@Nullable String url) {
        URL result = null;
        String fixedURL = Util.fixEmptyAndTrim((String)url);
        if (fixedURL != null) {
            try {
                return new URL(fixedURL);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return result;
    }

    @NonNull
    public List<String> secretsForMasking(Run<?, ?> build) {
        ArrayList<String> secretsForMasking = new ArrayList<String>();
        Map<String, StandardCredentials> resolveCredentials = this.resolveCredentials(build);
        for (StandardCredentials credential : resolveCredentials.values()) {
            if (credential instanceof UsernamePasswordCredentials) {
                UsernamePasswordCredentials userPassCredential = (UsernamePasswordCredentials)credential;
                String username = userPassCredential.getUsername();
                if (userPassCredential.isUsernameSecret()) {
                    secretsForMasking.add(userPassCredential.getUsername());
                }
                String password = Secret.toString((Secret)userPassCredential.getPassword());
                secretsForMasking.add(password);
                if (!password.isBlank()) {
                    secretsForMasking.add(Base64.encodeBase64String((byte[])password.getBytes(StandardCharsets.UTF_8)));
                }
                secretsForMasking.add(Base64.encodeBase64String((byte[])(username + ":" + password).getBytes(StandardCharsets.UTF_8)));
                continue;
            }
            if (!(credential instanceof StringCredentials)) continue;
            String tokenValue = Secret.toString((Secret)((StringCredentials)credential).getSecret());
            secretsForMasking.add(tokenValue);
        }
        return secretsForMasking;
    }
}

