/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.nextexecutions.utils;

import hudson.plugins.nextexecutions.NextBuilds;
import hudson.scheduler.CronTabList;
import hudson.triggers.Trigger;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.Map;
import jenkins.model.ParameterizedJobMixIn;
import org.jenkinsci.plugins.parameterizedscheduler.ParameterizedCronTab;
import org.jenkinsci.plugins.parameterizedscheduler.ParameterizedCronTabList;
import org.jenkinsci.plugins.parameterizedscheduler.ParameterizedTimerTrigger;
import org.kohsuke.accmod.restrictions.suppressions.SuppressRestrictedWarnings;

public class ParameterizedNextExecutionsUtils {
    private ParameterizedNextExecutionsUtils() {
    }

    @SuppressRestrictedWarnings(value={CronTabList.class})
    public static NextBuilds getNextBuild(ParameterizedJobMixIn.ParameterizedJob project, Class<? extends Trigger> triggerClass) {
        Calendar cal = null;
        Object timezone = null;
        if (project.isDisabled()) {
            return null;
        }
        Map triggers = project.getTriggers();
        Iterator iterator = triggers.entrySet().iterator();
        while (iterator.hasNext()) {
            Trigger trigger = (Trigger)iterator.next().getValue();
            if (!trigger.getClass().equals(triggerClass) || !triggerClass.equals(ParameterizedTimerTrigger.class)) continue;
            try {
                Field triggerTabsField = ParameterizedTimerTrigger.class.getDeclaredField("cronTabList");
                triggerTabsField.setAccessible(true);
                ParameterizedCronTabList parameterizedCronTabList = (ParameterizedCronTabList)triggerTabsField.get(trigger);
                Field crontablistTabsField = ParameterizedCronTabList.class.getDeclaredField("cronTabs");
                crontablistTabsField.setAccessible(true);
                ArrayList parameterizedCrons = (ArrayList)crontablistTabsField.get(parameterizedCronTabList);
                for (ParameterizedCronTab parameterizedCron : parameterizedCrons) {
                    Field crontablistField = ParameterizedCronTab.class.getDeclaredField("cronTabList");
                    crontablistField.setAccessible(true);
                    CronTabList list = (CronTabList)crontablistField.get(parameterizedCron);
                    Calendar next = list.next();
                    if (next == null || cal != null && !cal.after(next)) continue;
                    cal = next;
                }
            }
            catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
            }
        }
        if (cal != null) {
            return new NextBuilds(project, cal);
        }
        return null;
    }
}

