/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.nextexecutions;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Queue;
import hudson.model.TopLevelItem;
import hudson.model.View;
import hudson.plugins.nextexecutions.Messages;
import hudson.plugins.nextexecutions.NextBuilds;
import hudson.plugins.nextexecutions.utils.NextExecutionsUtils;
import hudson.plugins.nextexecutions.utils.ParameterizedNextExecutionsUtils;
import hudson.triggers.TimerTrigger;
import hudson.triggers.Trigger;
import hudson.widgets.Widget;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import jenkins.model.Jenkins;
import jenkins.model.ParameterizedJobMixIn;
import jenkins.widgets.WidgetFactory;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean
public class NextExecutionsWidget
extends Widget {
    @NonNull
    private final String ownerUrl;
    private Class<? extends Trigger> triggerClass;

    public NextExecutionsWidget(@NonNull String ownerUrl) {
        this(ownerUrl, TimerTrigger.class);
    }

    public NextExecutionsWidget(@NonNull String ownerUrl, Class<? extends Trigger> triggerClass) {
        this.ownerUrl = ownerUrl;
        this.triggerClass = triggerClass;
    }

    public String getOwnerUrl() {
        return this.ownerUrl;
    }

    @Exported(name="next_executions")
    public List<NextBuilds> getBuilds() {
        Vector<ParameterizedJobMixIn.ParameterizedJob> l;
        Vector<NextBuilds> nblist = new Vector<NextBuilds>();
        View v = (View)Stapler.getCurrentRequest2().findAncestorObject(View.class);
        Jenkins j = Jenkins.getInstanceOrNull();
        if (j == null) {
            return nblist;
        }
        NextBuilds.DescriptorImpl d = (NextBuilds.DescriptorImpl)j.getDescriptorOrDie(NextBuilds.class);
        if (d.getFilterByView() && v != null) {
            Collection tli = v.getItems();
            Vector<ParameterizedJobMixIn.ParameterizedJob> vector = new Vector<ParameterizedJobMixIn.ParameterizedJob>();
            Iterator iterator = tli.iterator();
            while (iterator.hasNext()) {
                TopLevelItem topLevelItem = (TopLevelItem)iterator.next();
                if (!(topLevelItem instanceof ParameterizedJobMixIn.ParameterizedJob)) continue;
                vector.add((ParameterizedJobMixIn.ParameterizedJob)topLevelItem);
            }
            l = vector;
        } else {
            l = j.getAllItems(ParameterizedJobMixIn.ParameterizedJob.class);
        }
        for (ParameterizedJobMixIn.ParameterizedJob project : l) {
            NextBuilds nb = NextExecutionsUtils.getNextBuild(project, this.triggerClass);
            if (nb != null) {
                nblist.add(nb);
                continue;
            }
            if (!this.getShowParameterizedWidget() || (nb = ParameterizedNextExecutionsUtils.getNextBuild(project, this.triggerClass)) == null) continue;
            nblist.add(nb);
        }
        if (((Object)((Object)this)).getClass() == NextExecutionsWidget.class) {
            Queue.Item[] queueItems;
            for (Queue.Item item : queueItems = Queue.getInstance().getItems()) {
                if (!(item instanceof Queue.WaitingItem) || !(item.task instanceof ParameterizedJobMixIn.ParameterizedJob)) continue;
                Queue.WaitingItem waitingItem = (Queue.WaitingItem)item;
                Calendar now = Calendar.getInstance();
                long nowMilliseconds = now.getTimeInMillis();
                now.setTimeInMillis(nowMilliseconds + 60000L);
                if (!waitingItem.timestamp.after(now)) continue;
                NextBuilds nb = new NextBuilds((ParameterizedJobMixIn.ParameterizedJob)item.task, waitingItem.timestamp);
                nblist.add(nb);
            }
        }
        Collections.sort(nblist);
        return nblist;
    }

    public String getWidgetName() {
        return Messages.NextExec_WidgetName();
    }

    public String getWidgetEmptyMessage() {
        return Messages.NextExec_EmptyWidgetMessage();
    }

    public String getWidgetId() {
        return "next-exec";
    }

    public boolean showWidget() {
        return true;
    }

    public boolean getShowParameterizedWidget() {
        NextBuilds.DescriptorImpl d;
        Jenkins j = Jenkins.getInstanceOrNull();
        NextBuilds.DescriptorImpl descriptorImpl = d = j != null ? (NextBuilds.DescriptorImpl)j.getDescriptorOrDie(NextBuilds.class) : null;
        if (d == null) {
            return false;
        }
        return d.getShowParameterizedWidget() && j.getPlugin("parameterized-scheduler") != null;
    }

    @Symbol(value={"nextExecutionsWidget"})
    @Extension
    public static final class FactoryImpl
    extends WidgetFactory<View, NextExecutionsWidget> {
        public Class<View> type() {
            return View.class;
        }

        public Class<NextExecutionsWidget> widgetType() {
            return NextExecutionsWidget.class;
        }

        @NonNull
        public Collection<NextExecutionsWidget> createFor(@NonNull View target) {
            return List.of(new NextExecutionsWidget(target.getUrl()));
        }
    }
}

