/*
 * Decompiled with CFR 0.152.
 */
package com.netsparker.cloud.model;

import com.netsparker.cloud.model.ProxyBlock;
import com.netsparker.cloud.model.ScanRequestBase;
import com.netsparker.cloud.model.WebsiteModel;
import com.netsparker.cloud.model.WebsiteProfileModel;
import com.netsparker.cloud.utility.AppCommon;
import hudson.util.Secret;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class WebsiteModelRequest
extends ScanRequestBase {
    private ArrayList<WebsiteModel> websiteModels = new ArrayList();
    private final URI pluginWebSiteModelsUri = new URL(this.ApiURL, "api/1.0/scans/PluginWebSiteModels").toURI();

    public WebsiteModelRequest(String apiURL, Secret apiToken, ProxyBlock proxy) throws MalformedURLException, NullPointerException, URISyntaxException {
        super(apiURL, apiToken, proxy);
    }

    public ArrayList<WebsiteModel> getWebsiteModels() {
        return this.websiteModels;
    }

    public ClassicHttpResponse getPluginWebSiteModels() throws IOException, ParseException {
        CloseableHttpClient httpClient = this.getHttpClient();
        HttpGet httpGet = new HttpGet(this.pluginWebSiteModelsUri);
        httpGet.setHeader("Accept", (Object)"application/json");
        httpGet.setHeader("Authorization", (Object)this.getAuthHeader());
        ClassicHttpResponse response = (ClassicHttpResponse)httpClient.execute((ClassicHttpRequest)httpGet);
        if (response.getCode() == 200) {
            this.parseWebsiteData(response);
        }
        return response;
    }

    private void parseWebsiteData(ClassicHttpResponse response) throws ParseException, IOException {
        String data = AppCommon.parseResponseToString(response);
        JSONParser parser = new JSONParser();
        Object jsonData = parser.parse(data);
        JSONArray WebsiteModelObjects = (JSONArray)jsonData;
        this.websiteModels = new ArrayList();
        for (Object wmo : WebsiteModelObjects) {
            if (!(wmo instanceof JSONObject)) continue;
            JSONObject websiteModelObject = (JSONObject)wmo;
            WebsiteModel websiteModel = new WebsiteModel();
            websiteModel.setId((String)websiteModelObject.get((Object)"Id"));
            websiteModel.setName((String)websiteModelObject.get((Object)"Name"));
            websiteModel.setUrl((String)websiteModelObject.get((Object)"Url"));
            JSONArray WebsiteProfileModelObjects = (JSONArray)websiteModelObject.get((Object)"WebsiteProfiles");
            ArrayList<WebsiteProfileModel> profiles = new ArrayList<WebsiteProfileModel>();
            for (Object wmpo : WebsiteProfileModelObjects) {
                JSONObject websiteProfileModelObject = (JSONObject)wmpo;
                WebsiteProfileModel websiteProfileModel = new WebsiteProfileModel();
                websiteProfileModel.setId((String)websiteProfileModelObject.get((Object)"Id"));
                websiteProfileModel.setName((String)websiteProfileModelObject.get((Object)"Name"));
                profiles.add(websiteProfileModel);
            }
            websiteModel.setProfiles(profiles);
            this.websiteModels.add(websiteModel);
        }
    }
}

