/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.maven_artifact_choicelistprovider;

import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.maven_artifact_choicelistprovider.ValidAndInvalidClassifier;

public abstract class RESTfulParameterBuilder {
    public static final String PACKAGING_ALL = "*";
    public static final String CLASSIFIER_ALL = "*";
    public static final String DEFAULT_SORTORDER = "version";
    private static final Logger LOGGER = Logger.getLogger(RESTfulParameterBuilder.class.getName());

    public MultivaluedMap<String, String> create(String pRepositoryId, String pName) {
        return this.create(pRepositoryId, null, pName, null, null, "");
    }

    public MultivaluedMap<String, String> create(String pRepositoryId, String pGroup, String pName, String pToken) {
        return this.create(pRepositoryId, pGroup, pName, null, null, pToken);
    }

    public MultivaluedMap<String, String> create(String pRepositoryId, String pGroupId, String pArtifactId, String pPackaging, ValidAndInvalidClassifier pClassifier) {
        return this.create(pRepositoryId, pGroupId, pArtifactId, pPackaging, pClassifier, "");
    }

    public MultivaluedMap<String, String> create(String pRepositoryId, String pGroupId, String pArtifactId, String pPackaging, ValidAndInvalidClassifier pClassifier, String pToken) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("create parameters for: repositoryId: " + pRepositoryId + " g:" + pGroupId + ", a:" + pArtifactId + ", p:" + pPackaging + ", c: " + (pClassifier == null ? "null" : pClassifier.toString()) + " t:" + pToken);
        }
        MultivaluedHashMap requestParams = new MultivaluedHashMap();
        if (!StringUtils.isEmpty((String)pRepositoryId)) {
            requestParams.putSingle((Object)this.getRepositoryId(), (Object)pRepositoryId);
        }
        if (!StringUtils.isEmpty((String)pGroupId)) {
            requestParams.putSingle((Object)this.getGroupId(), (Object)pGroupId);
        }
        if (!StringUtils.isEmpty((String)pArtifactId)) {
            requestParams.putSingle((Object)this.getArtifactId(), (Object)pArtifactId);
        }
        if (!StringUtils.isEmpty((String)pPackaging) && !"*".equals(pPackaging)) {
            requestParams.putSingle((Object)this.getPackaging(), (Object)pPackaging);
        }
        if (pClassifier != null && !StringUtils.isEmpty((String)this.getClassifier())) {
            boolean retrieveAllClassifiers = false;
            ArrayList<String> query = new ArrayList<String>();
            for (String current : pClassifier.getValid()) {
                query.add(current);
                if (!"*".equals(current)) continue;
                retrieveAllClassifiers = true;
            }
            if (!retrieveAllClassifiers && pClassifier.getInvalid().isEmpty()) {
                if (!query.isEmpty()) {
                    requestParams.put((Object)this.getClassifier(), query);
                } else {
                    requestParams.putSingle((Object)this.getClassifier(), (Object)"");
                }
            }
        }
        if (!StringUtils.isEmpty((String)pToken)) {
            requestParams.putSingle((Object)this.getContinuationToken(), (Object)pToken);
        }
        requestParams.putSingle((Object)this.getSortOrder(), (Object)DEFAULT_SORTORDER);
        return requestParams;
    }

    public abstract String getRepositoryId();

    public abstract String getGroupId();

    public abstract String getArtifactId();

    public abstract String getPackaging();

    public abstract String getClassifier();

    public abstract String getContinuationToken();

    public abstract String getSortOrder();
}

