/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.maven_artifact_choicelistprovider;

import hudson.model.Descriptor;
import hudson.util.FormValidation;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import jp.ikedam.jenkins.plugins.extensible_choice_parameter.ChoiceListProvider;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.maven_artifact_choicelistprovider.IVersionReader;
import org.kohsuke.stapler.QueryParameter;

public abstract class AbstractMavenArtifactDescriptorImpl
extends Descriptor<ChoiceListProvider> {
    public FormValidation doCheckGroupId(@QueryParameter String groupId, @QueryParameter String artifactId) {
        if (StringUtils.isBlank((String)groupId) && StringUtils.isBlank((String)artifactId)) {
            return FormValidation.error((String)"The groudId cannot be empty. Please fill at least GroupId or ArtifactId.");
        }
        return FormValidation.ok();
    }

    public FormValidation doCheckArtifactId(@QueryParameter String artifactId, @QueryParameter String groupId) {
        if (StringUtils.isBlank((String)artifactId) && StringUtils.isBlank((String)groupId)) {
            return FormValidation.error((String)"The artifactId cannot be empty. Please fill at least ArtifactId or GroupId.");
        }
        return FormValidation.ok();
    }

    public FormValidation doCheckPackaging(@QueryParameter String packaging) {
        if (!StringUtils.isBlank((String)packaging) && packaging.startsWith(".")) {
            return FormValidation.error((String)"packaging must not start with a .");
        }
        return FormValidation.ok();
    }

    public FormValidation doCheckClassifier(@QueryParameter String classifier) {
        if (StringUtils.isBlank((String)classifier)) {
            return FormValidation.ok((String)"OK, will not filter for any classifier");
        }
        return FormValidation.ok();
    }

    public FormValidation doCheckFilterExpression(@QueryParameter String filterExpression) {
        if (StringUtils.isEmpty((String)filterExpression)) {
            return FormValidation.warning((String)"Although blank string is a syntactically valid regular expression, it would result no match. To maintain backward compatibility of the plugin, blank string is considered as match all. Please explicitly type '.*' instead (without quotes) to remove this warning.");
        }
        try {
            Pattern.compile(filterExpression);
        }
        catch (PatternSyntaxException pse) {
            return FormValidation.error((String)"Filter Expression is not a valid regular expression. Try '.*' instead (without quotes). Please check https://docs.oracle.com/javase/8/docs/api/java/util/regex/Pattern.html for the accepted syntax");
        }
        return FormValidation.ok();
    }

    public FormValidation performTest(IVersionReader pService, @QueryParameter String repositoryId, @QueryParameter String groupId, @QueryParameter String artifactId, @QueryParameter String packaging, @QueryParameter String classifier, @QueryParameter boolean inverseFilter, @QueryParameter String filterExpression, @QueryParameter boolean reverseOrder) {
        if (StringUtils.isEmpty((String)packaging) && !StringUtils.isEmpty((String)classifier)) {
            return FormValidation.error((String)"You have choosen an empty Packaging configuration but have configured a Classifier. Please either define a Packaging value or remove the Classifier");
        }
        try {
            Map<String, String> entriesFromURL = this.wrapTestConnection(pService, repositoryId, groupId, artifactId, packaging, classifier, inverseFilter, filterExpression, reverseOrder);
            if (entriesFromURL.isEmpty()) {
                return FormValidation.ok((String)"(Working, but no Entries found)");
            }
            return FormValidation.ok((String)StringUtils.join(entriesFromURL.values(), (char)'\n'));
        }
        catch (Exception e) {
            return FormValidation.error((String)("error reading versions from url:" + e.getMessage()));
        }
    }

    protected abstract Map<String, String> wrapTestConnection(IVersionReader var1, String var2, String var3, String var4, String var5, String var6, boolean var7, String var8, boolean var9);
}

