/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.maven_artifact_choicelistprovider;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.cloudbees.plugins.credentials.impl.UsernamePasswordCredentialsImpl;
import hudson.Extension;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.Queue;
import hudson.model.queue.Tasks;
import hudson.security.ACL;
import hudson.util.ListBoxModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import jp.ikedam.jenkins.plugins.extensible_choice_parameter.ChoiceListProvider;
import jp.ikedam.jenkins.plugins.extensible_choice_parameter.ExtensibleChoiceParameterDefinition;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.maven_artifact_choicelistprovider.IVersionReader;
import org.jenkinsci.plugins.maven_artifact_choicelistprovider.MavenArtifactChoiceListProviderUtils;
import org.jenkinsci.plugins.maven_artifact_choicelistprovider.ValidAndInvalidClassifier;
import org.jenkinsci.plugins.maven_artifact_choicelistprovider.VersionReaderException;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest2;
import org.springframework.security.core.Authentication;

public abstract class AbstractMavenArtifactChoiceListProvider
extends ChoiceListProvider {
    public static final String DEFAULT_REGEX_MATCH_ALL = ".*";
    private static final long serialVersionUID = -6055763342458172275L;
    private static final Logger LOGGER = Logger.getLogger(AbstractMavenArtifactChoiceListProvider.class.getName());
    private String repositoryId;
    private String groupId;
    private String artifactId;
    private String packaging;
    private String classifier;
    private boolean inverseFilter;
    private String filterExpression;
    private boolean reverseOrder;

    public AbstractMavenArtifactChoiceListProvider(String artifactId) {
        this.setArtifactId(artifactId);
    }

    public List<String> getChoiceList() {
        Map<Object, Object> mChoices;
        StaplerRequest2 req = Stapler.getCurrentRequest2();
        if (req != null) {
            Item item = (Item)req.findAncestorObject(Item.class);
            IVersionReader serviceInstance = this.createServiceInstance(item);
            LOGGER.log(Level.FINE, "retrieve the versions from the repository");
            mChoices = AbstractMavenArtifactChoiceListProvider.readURL(serviceInstance, this.getRepositoryId(), this.getGroupId(), this.getArtifactId(), this.getPackaging(), this.getClassifier(), this.getInverseFilter(), this.getFilterExpression(), this.getReverseOrder());
        } else {
            mChoices = Collections.emptyMap();
        }
        return new LinkedList<String>(mChoices.values());
    }

    public abstract IVersionReader createServiceInstance(Item var1);

    public static UsernamePasswordCredentialsImpl getCredentials(@Nonnull String pCredentialId, @Nonnull Item pItem) {
        Authentication acl = pItem instanceof Queue.Task ? Tasks.getAuthenticationOf2((Queue.Task)((Queue.Task)pItem)) : ACL.SYSTEM2;
        return (UsernamePasswordCredentialsImpl)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentialsInItem(UsernamePasswordCredentialsImpl.class, (Item)pItem, (Authentication)acl, Collections.emptyList()), (CredentialsMatcher)CredentialsMatchers.allOf((CredentialsMatcher[])new CredentialsMatcher[]{CredentialsMatchers.withId((String)pCredentialId)}));
    }

    public static Map<String, String> readURL(IVersionReader pInstance, String pRepositoryId, String pGroupId, String pArtifactId, String pPackaging, String pClassifier, boolean pInverseFilter, String pFilterExpression, boolean pReverseOrder) {
        Map<String, String> retVal = new LinkedHashMap<String, String>();
        try {
            ValidAndInvalidClassifier classifierBox = ValidAndInvalidClassifier.fromString(pClassifier);
            List<String> choices = pInstance.retrieveVersions(pRepositoryId, pGroupId, pArtifactId, pPackaging, classifierBox);
            List<String> filteredChoices = AbstractMavenArtifactChoiceListProvider.filterArtifacts(choices, pInverseFilter, pFilterExpression);
            if (pReverseOrder) {
                Collections.reverse(filteredChoices);
            }
            retVal = MavenArtifactChoiceListProviderUtils.toMap(filteredChoices);
        }
        catch (VersionReaderException e) {
            LOGGER.log(Level.INFO, "failed to retrieve versions from repository for g:" + pGroupId + ", a:" + pArtifactId + ", p:" + pPackaging + ", c:" + pClassifier, e);
            retVal.put("error", e.getMessage());
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "failed to retrieve versions from nexus for g:" + pGroupId + ", a:" + pArtifactId + ", p:" + pPackaging + ", c:" + pClassifier, e);
            retVal.put("error", "Unexpected Error: " + e.getMessage());
        }
        return retVal;
    }

    public static List<String> filterArtifacts(List<String> pChoices, boolean pInverseFilter, String pFilterExpression) {
        List<String> retVal;
        if (StringUtils.isEmpty((String)pFilterExpression) || DEFAULT_REGEX_MATCH_ALL.equals(pFilterExpression)) {
            LOGGER.log(Level.FINE, "do not filter artifacts.");
            retVal = pChoices;
        } else {
            LOGGER.log(Level.FINE, "filter artifacts based on " + pFilterExpression + ", inverse: " + pInverseFilter);
            retVal = new ArrayList<String>();
            Pattern compiledFilter = Pattern.compile(StringUtils.isEmpty((String)pFilterExpression) ? DEFAULT_REGEX_MATCH_ALL : pFilterExpression);
            for (String choice : pChoices) {
                boolean match = compiledFilter.matcher(choice).matches();
                if (!(pInverseFilter ^ match)) continue;
                retVal.add(choice);
            }
        }
        return retVal;
    }

    public void onBuildCompletedWithValue(AbstractBuild<?, ?> build, ExtensibleChoiceParameterDefinition def, String value) {
        super.onBuildCompletedWithValue(build, def, value);
        LOGGER.log(Level.INFO, "onBuildCompletedWithValue" + value);
    }

    public void onBuildTriggeredWithValue(AbstractProject<?, ?> job, ExtensibleChoiceParameterDefinition def, String value) {
        super.onBuildTriggeredWithValue(job, def, value);
        LOGGER.log(Level.INFO, "onBuildTriggeredWithValue: " + value);
    }

    @DataBoundSetter
    public void setGroupId(String groupId) {
        this.groupId = StringUtils.trim((String)groupId);
    }

    @DataBoundSetter
    public void setArtifactId(String artifactId) {
        this.artifactId = StringUtils.trim((String)artifactId);
    }

    @DataBoundSetter
    public void setPackaging(String packaging) {
        this.packaging = StringUtils.trim((String)packaging);
    }

    @DataBoundSetter
    public void setClassifier(String classifier) {
        this.classifier = StringUtils.trim((String)classifier);
    }

    @DataBoundSetter
    public void setInverseFilter(boolean inverseFilter) {
        this.inverseFilter = inverseFilter;
    }

    @DataBoundSetter
    public void setFilterExpression(String filterExpression) {
        this.filterExpression = filterExpression;
    }

    @DataBoundSetter
    public void setReverseOrder(boolean reverseOrder) {
        this.reverseOrder = reverseOrder;
    }

    @DataBoundSetter
    public void setRepositoryId(String repositoryId) {
        this.repositoryId = repositoryId;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getPackaging() {
        return this.packaging;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public boolean getInverseFilter() {
        return this.inverseFilter;
    }

    public String getFilterExpression() {
        return this.filterExpression;
    }

    public boolean getReverseOrder() {
        return this.reverseOrder;
    }

    public String getRepositoryId() {
        return this.repositoryId;
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<ChoiceListProvider> {
        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath Item item, @QueryParameter String credentialsId) {
            StandardListBoxModel result = new StandardListBoxModel();
            if (item == null ? !Jenkins.get().hasPermission(Jenkins.ADMINISTER) : !item.hasPermission(Item.EXTENDED_READ) && !item.hasPermission(CredentialsProvider.USE_ITEM)) {
                return result.includeCurrentValue(credentialsId);
            }
            Authentication acl = item instanceof Queue.Task ? Tasks.getAuthenticationOf2((Queue.Task)((Queue.Task)item)) : ACL.SYSTEM2;
            return result.includeEmptyValue().includeMatchingAs(item instanceof Queue.Task ? Tasks.getAuthenticationOf2((Queue.Task)((Queue.Task)item)) : acl, item, StandardUsernamePasswordCredentials.class, Collections.emptyList(), CredentialsMatchers.instanceOf(StandardUsernamePasswordCredentials.class)).includeCurrentValue(credentialsId);
        }
    }
}

