/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.maven_artifact_choicelistprovider;

import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLHandshakeException;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.ResponseProcessingException;
import javax.ws.rs.client.WebTarget;
import org.apache.commons.lang.StringUtils;
import org.glassfish.jersey.client.authentication.HttpAuthenticationFeature;
import org.jenkinsci.plugins.maven_artifact_choicelistprovider.IVersionReader;
import org.jenkinsci.plugins.maven_artifact_choicelistprovider.ValidAndInvalidClassifier;
import org.jenkinsci.plugins.maven_artifact_choicelistprovider.VersionReaderException;

public abstract class AbstractRESTfulVersionReader
implements IVersionReader {
    private static final int SERVICE_READ_TIMEOUT = 5000;
    protected static final String PACKAGING_ALL = "*";
    private static final Logger LOGGER = Logger.getLogger(AbstractRESTfulVersionReader.class.getName());
    private final String mURL;
    private String mUserName;
    private String mUserPassword;
    private WebTarget mInstance;

    public AbstractRESTfulVersionReader(String pURL) {
        this.mURL = pURL;
    }

    void init() {
        Client client = ClientBuilder.newClient();
        if (StringUtils.isNotEmpty((String)this.mUserName) && StringUtils.isNotEmpty((String)this.mUserPassword)) {
            LOGGER.fine("setting username to: " + this.mUserName);
            HttpAuthenticationFeature feature = HttpAuthenticationFeature.basic((String)this.mUserName, (String)this.mUserPassword);
            client.register((Object)feature);
        } else {
            LOGGER.fine("no username AND password provided");
        }
        client.property("jersey.config.client.readTimeout", (Object)this.getTimeout());
        this.mInstance = client.target(this.getURL()).path(this.getRESTfulServiceEndpoint());
        LOGGER.info("repository search service at: " + this.mInstance.getUri().toString());
    }

    public List<String> retrieveVersions(String pRepositoryId, String pGroup, String pName) throws VersionReaderException {
        return this.retrieveVersions(pRepositoryId, pGroup, pName, null, null);
    }

    @Override
    public List<String> retrieveVersions(String pRepositoryId, String pGroupId, String pArtifactId, String pPackaging, ValidAndInvalidClassifier pClassifier) throws VersionReaderException {
        try {
            Set<String> result = this.callService(pRepositoryId, pGroupId, pArtifactId, pPackaging, pClassifier);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "result: " + result.size());
                for (String current : result) {
                    LOGGER.log(Level.FINE, current);
                }
            }
            return new LinkedList<String>(result);
        }
        catch (ResponseProcessingException e) {
            Object msg;
            if (e.getResponse() != null) {
                switch (e.getResponse().getStatus()) {
                    case 401: {
                        msg = "Your repository requires user-authentication. Please configure a username and a password to list the content of this repository";
                        break;
                    }
                    case 404: {
                        msg = "The artifact you are looking for does not exist (HTTP404). Have you used the correct repositoryId? For Nexus 3 please check Plugin Release Notes";
                        break;
                    }
                    default: {
                        msg = "HTTP Server Error: " + e.getResponse().getStatus() + ": " + e.getMessage();
                        break;
                    }
                }
            } else {
                msg = "General Error:" + e.getMessage();
            }
            throw new VersionReaderException((String)msg, e);
        }
        catch (NotFoundException e) {
            throw new VersionReaderException("The artifact you are looking for does not exist (HTTP404). Have you used the correct repositoryId / baseURL?", e);
        }
        catch (VersionReaderException e) {
            throw e;
        }
        catch (Exception e) {
            if (e.getCause() instanceof SSLHandshakeException) {
                throw new VersionReaderException("The certificate of the target repository is untrusted by this JVM", e);
            }
            if (e instanceof ProcessingException) {
                throw new VersionReaderException("Timeout while connecting to your Repository Service. Please consider the Jenkins-Proxy settings. If using HTTPs also invalid certificates can be the root cause.", e);
            }
            if (e instanceof BadRequestException) {
                throw new VersionReaderException("Request is invalid", e);
            }
            throw new VersionReaderException("failed to retrieve versions from repository for r:" + this.getURL() + ", g:" + pGroupId + ", a:" + pArtifactId + ", p:" + pPackaging + ", c:" + String.valueOf(pClassifier), e);
        }
    }

    public String getURL() {
        return this.mURL;
    }

    protected WebTarget getInstance() {
        if (this.mInstance == null) {
            this.init();
        }
        return this.mInstance;
    }

    public String getUserName() {
        return this.mUserName;
    }

    @Override
    public void setUserName(String mUserName) {
        this.mUserName = mUserName;
    }

    @Override
    public void setUserPassword(String mUserPassword) {
        this.mUserPassword = mUserPassword;
    }

    @Override
    public void setCredentials(String pUserName, String pUserPassword) {
        this.setUserName(pUserName);
        this.setUserPassword(pUserPassword);
    }

    protected int getTimeout() {
        return 5000;
    }

    public abstract String getRESTfulServiceEndpoint();

    public abstract Set<String> callService(String var1, String var2, String var3, String var4, ValidAndInvalidClassifier var5) throws VersionReaderException;
}

