/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.jobcacher.arbitrary;

import hudson.FilePath;
import java.io.IOException;
import jenkins.plugins.itemstorage.ObjectPath;
import jenkins.plugins.jobcacher.arbitrary.ArbitraryFileCacheStrategy;
import jenkins.plugins.jobcacher.arbitrary.WorkspaceHelper;

public abstract class AbstractCompressingArbitraryFileCacheStrategy
implements ArbitraryFileCacheStrategy {
    @Override
    public String createCacheName(String cacheBaseName) {
        return cacheBaseName + this.getArchiveExtension();
    }

    @Override
    public void cache(FilePath localSource, String includes, String excludes, boolean useDefaultExcludes, ObjectPath remoteTarget, FilePath workspace) throws IOException, InterruptedException {
        try (WorkspaceHelper.TempFile localTarget = WorkspaceHelper.createTempFile(workspace, this.getArchiveExtension());){
            this.compress(localSource, includes, excludes, useDefaultExcludes, localTarget.get());
            remoteTarget.copyFrom(localTarget.get());
        }
    }

    @Override
    public void restore(ObjectPath remoteSource, FilePath localTarget, FilePath workspace) throws IOException, InterruptedException {
        localTarget.mkdirs();
        try (WorkspaceHelper.TempFile localSource = WorkspaceHelper.createTempFile(workspace, this.getArchiveExtension());){
            remoteSource.copyTo(localSource.get());
            this.uncompress(localSource.get(), localTarget);
        }
    }

    protected abstract String getArchiveExtension();

    protected abstract void uncompress(FilePath var1, FilePath var2) throws IOException, InterruptedException;

    protected abstract void compress(FilePath var1, String var2, String var3, boolean var4, FilePath var5) throws IOException, InterruptedException;
}

