package hudson.plugins.jira.selector;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.ExtensionPoint;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.jira.JiraSite;
import java.util.Set;

/**
 * Strategy of finding issues which should be updated after completed run.
 *
 * @author Franta Mejta
 */
public abstract class AbstractIssueSelector extends AbstractDescribableImpl<AbstractIssueSelector>
        implements ExtensionPoint {

    /**
     * Finds the strings that match Jira issue ID patterns.
     *
     * This method returns all likely candidates and shouldn't check
     * if such ID actually exists or not.
     *
     * @param run The completed run.
     * @param site Jira site configured for current job.
     * @param listener Current's run listener.
     * @return Set of ids of issues which should be updated.
     */
    public abstract Set<String> findIssueIds(
            @NonNull Run<?, ?> run, @NonNull JiraSite site, @NonNull TaskListener listener);
}
