/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.ivytrigger;

import hudson.FilePath;
import hudson.remoting.VirtualChannel;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import jenkins.MasterToSlaveFileCallable;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.ivy.Ivy;
import org.apache.ivy.core.module.descriptor.Artifact;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.report.ArtifactDownloadReport;
import org.apache.ivy.core.report.ResolveReport;
import org.apache.ivy.core.resolve.IvyNode;
import org.apache.ivy.core.resolve.ResolveOptions;
import org.apache.ivy.core.settings.IvySettings;
import org.apache.ivy.core.settings.IvyVariableContainer;
import org.apache.ivy.core.settings.IvyVariableContainerImpl;
import org.apache.ivy.util.MessageLogger;
import org.jenkinsci.plugins.ivytrigger.IvyArtifactValue;
import org.jenkinsci.plugins.ivytrigger.IvyDependencyValue;
import org.jenkinsci.plugins.ivytrigger.IvyTriggerResolverLog;
import org.jenkinsci.plugins.xtriggerapi.XTriggerException;
import org.jenkinsci.plugins.xtriggerapi.XTriggerLog;

public class IvyTriggerEvaluator
extends MasterToSlaveFileCallable<Map<String, IvyDependencyValue>> {
    private final String namespace;
    private final FilePath ivyFilePath;
    private final FilePath ivySettingsFilePath;
    private final URL ivySettingsURL;
    private final FilePath propertiesFilePath;
    private final String propertiesContent;
    private final XTriggerLog log;
    private final boolean debug;
    private final boolean downloadArtifacts;
    private final Map<String, String> envVars;

    public IvyTriggerEvaluator(String namespace, FilePath ivyFilePath, FilePath ivySettingsFilePath, URL ivySettingsURL, FilePath propertiesFilePath, String propertiesContent, XTriggerLog log, boolean debug, boolean downloadArtifacts, Map<String, String> envVars) {
        this.namespace = namespace;
        this.ivyFilePath = ivyFilePath;
        this.ivySettingsFilePath = ivySettingsFilePath;
        this.ivySettingsURL = ivySettingsURL;
        this.propertiesFilePath = propertiesFilePath;
        this.propertiesContent = propertiesContent;
        this.log = log;
        this.debug = debug;
        this.downloadArtifacts = downloadArtifacts;
        this.envVars = envVars;
    }

    public Map<String, IvyDependencyValue> invoke(File launchDir, VirtualChannel channel) throws IOException, InterruptedException {
        try {
            List problems;
            Ivy ivy = this.getIvyObject(launchDir, this.log);
            this.log.info("\nResolving Ivy dependencies.");
            ResolveOptions options = new ResolveOptions();
            options.setDownload(this.downloadArtifacts);
            File ivyFile = new File(this.ivyFilePath.getRemote());
            ResolveReport resolveReport = ivy.resolve(ivyFile, options);
            if (resolveReport.hasError() && (problems = resolveReport.getAllProblemMessages()) != null && !problems.isEmpty()) {
                StringBuilder errorMsgs = new StringBuilder();
                errorMsgs.append("Errors:\n");
                for (Object problem : problems) {
                    errorMsgs.append(problem);
                    errorMsgs.append("\n");
                }
                this.log.error(errorMsgs.toString());
            }
            return this.getMapDependencies(ivy, resolveReport, this.log);
        }
        catch (ParseException pe) {
            this.log.error("Parsing error: " + pe.getMessage());
            return null;
        }
        catch (IOException ioe) {
            this.log.error("IOException: " + ioe.getMessage());
            return null;
        }
        catch (XTriggerException xe) {
            this.log.error("XTrigger exception: " + xe.getMessage());
            return null;
        }
    }

    private Ivy getIvyObject(File launchDir, XTriggerLog log) throws XTriggerException {
        File tempSettingsFile = null;
        try {
            IvyVariableContainerImpl variables = new IvyVariableContainerImpl(this.getVariables());
            String settingsContent = this.getIvySettingsContents();
            tempSettingsFile = File.createTempFile("file", ".tmp");
            FileUtils.write((File)tempSettingsFile, (CharSequence)settingsContent, (Charset)StandardCharsets.UTF_8);
            IvySettings ivySettings = new IvySettings((IvyVariableContainer)variables);
            ivySettings.load(tempSettingsFile);
            ivySettings.setDefaultCache(this.getAndInitCacheDir(launchDir));
            Ivy ivy = Ivy.newInstance((IvySettings)ivySettings);
            ivy.getLoggerEngine().pushLogger((MessageLogger)new IvyTriggerResolverLog(log, this.debug));
            Ivy ivy2 = ivy;
            return ivy2;
        }
        catch (IOException | ParseException e) {
            throw new XTriggerException((Throwable)e);
        }
        finally {
            if (tempSettingsFile != null && !tempSettingsFile.delete()) {
                log.error("Can't delete temporary file: " + tempSettingsFile);
            }
        }
    }

    private String getIvySettingsContents() throws IOException {
        if (this.ivySettingsFilePath != null) {
            this.log.info("Getting settings from file " + this.ivySettingsFilePath.getRemote());
            return FileUtils.readFileToString((File)new File(this.ivySettingsFilePath.getRemote()), (Charset)StandardCharsets.UTF_8);
        }
        this.log.info("Getting settings from URL " + this.ivySettingsURL.toString());
        try (InputStream is = this.ivySettingsURL.openStream();){
            String string = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
            return string;
        }
    }

    private Map<String, String> getVariables() throws XTriggerException {
        TreeMap<String, String> variables;
        block10: {
            variables = new TreeMap<String, String>();
            try {
                if (this.envVars != null) {
                    variables.putAll(this.envVars);
                }
                if (this.propertiesFilePath != null) {
                    this.propertiesFilePath.act((FilePath.FileCallable)new MasterToSlaveFileCallable<Void>(){

                        public Void invoke(File f, VirtualChannel channel) throws IOException, InterruptedException {
                            Properties properties = new Properties();
                            try (FileInputStream stream = new FileInputStream(IvyTriggerEvaluator.this.propertiesFilePath.getRemote());
                                 InputStreamReader streamReader = new InputStreamReader((InputStream)stream, StandardCharsets.ISO_8859_1);){
                                properties.load(streamReader);
                            }
                            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                                variables.put(String.valueOf(entry.getKey()), String.valueOf(entry.getValue()));
                            }
                            return null;
                        }
                    });
                }
                if (this.propertiesContent == null) break block10;
                Properties properties = new Properties();
                try (StringReader stringReader = new StringReader(this.propertiesContent);){
                    properties.load(stringReader);
                }
                for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                    variables.put(String.valueOf(entry.getKey()), String.valueOf(entry.getValue()));
                }
            }
            catch (IOException | InterruptedException e) {
                throw new XTriggerException((Throwable)e);
            }
        }
        return variables;
    }

    private File getAndInitCacheDir(File launchDir) throws IOException {
        File cacheDir = new File(launchDir, "ivy-trigger-cache/" + this.namespace);
        FileUtils.forceMkdir((File)cacheDir);
        return cacheDir;
    }

    private Map<String, IvyDependencyValue> getMapDependencies(Ivy ivy, ResolveReport resolveReport, XTriggerLog log) {
        List dependencies = resolveReport.getDependencies();
        HashMap<String, IvyDependencyValue> result = new HashMap<String, IvyDependencyValue>();
        for (Object dependencyObject : dependencies) {
            try {
                IvyNode dependencyNode = (IvyNode)dependencyObject;
                ModuleRevisionId moduleRevisionId = dependencyNode.getResolvedId();
                String moduleRevision = moduleRevisionId.getRevision();
                ArtifactDownloadReport[] downloadReports = resolveReport.getConfigurationReport(dependencyNode.getRootModuleConfigurations()[0]).getDownloadReports(moduleRevisionId);
                ArrayList<IvyArtifactValue> ivyArtifactValues = new ArrayList<IvyArtifactValue>();
                Artifact[] artifacts = dependencyNode.getAllArtifacts();
                boolean itemsDownloaded = false;
                for (ArtifactDownloadReport downloadReport : downloadReports) {
                    if (!downloadReport.isDownloaded()) continue;
                    itemsDownloaded = true;
                }
                if (itemsDownloaded) {
                    for (ArtifactDownloadReport downloadReport : downloadReports) {
                        File localFile = downloadReport.getLocalFile();
                        long lastModificationDate = localFile.lastModified();
                        String artifactName = downloadReport.getArtifact().getName();
                        String artifactExt = downloadReport.getArtifact().getExt();
                        ivyArtifactValues.add(new IvyArtifactValue(artifactName, artifactExt, lastModificationDate));
                    }
                }
                result.put(dependencyNode.getId().toString(), new IvyDependencyValue(moduleRevision, ivyArtifactValues));
            }
            catch (Throwable e) {
                log.error("Can't retrieve artifacts for dependency " + dependencyObject);
            }
        }
        return result;
    }
}

