/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.ivytrigger;

import antlr.ANTLRException;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.FilePath;
import hudson.Util;
import hudson.console.AnnotatedLargeText;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildableItem;
import hudson.model.Job;
import hudson.model.Node;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.jelly.XMLOutput;
import org.jenkinsci.lib.envinject.EnvInjectException;
import org.jenkinsci.plugins.envinjectapi.util.EnvVarsResolver;
import org.jenkinsci.plugins.ivytrigger.IvyArtifactValue;
import org.jenkinsci.plugins.ivytrigger.IvyDependencyValue;
import org.jenkinsci.plugins.ivytrigger.IvyTriggerAction;
import org.jenkinsci.plugins.ivytrigger.IvyTriggerContext;
import org.jenkinsci.plugins.ivytrigger.IvyTriggerEvaluator;
import org.jenkinsci.plugins.ivytrigger.LabelRestrictionClass;
import org.jenkinsci.plugins.ivytrigger.util.FilePathFactory;
import org.jenkinsci.plugins.ivytrigger.util.PropertiesFileContentExtractor;
import org.jenkinsci.plugins.xtriggerapi.AbstractTriggerByFullContext;
import org.jenkinsci.plugins.xtriggerapi.XTriggerDescriptor;
import org.jenkinsci.plugins.xtriggerapi.XTriggerException;
import org.jenkinsci.plugins.xtriggerapi.XTriggerLog;
import org.kohsuke.stapler.DataBoundConstructor;

public class IvyTrigger
extends AbstractTriggerByFullContext<IvyTriggerContext>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String ivyPath;
    private final String ivySettingsPath;
    private final String propertiesFilePath;
    private final String propertiesContent;
    private final boolean debug;
    private final boolean labelRestriction;
    private final boolean enableConcurrentBuild;
    private final boolean downloadArtifacts;

    @DataBoundConstructor
    public IvyTrigger(String cronTabSpec, String ivyPath, String ivySettingsPath, String propertiesFilePath, String propertiesContent, LabelRestrictionClass labelRestriction, boolean enableConcurrentBuild, boolean debug, boolean downloadArtifacts) throws ANTLRException {
        super(cronTabSpec, labelRestriction == null ? null : labelRestriction.getTriggerLabel(), enableConcurrentBuild);
        this.ivyPath = Util.fixEmptyAndTrim((String)ivyPath);
        this.ivySettingsPath = Util.fixEmptyAndTrim((String)ivySettingsPath);
        this.propertiesFilePath = Util.fixEmptyAndTrim((String)propertiesFilePath);
        this.propertiesContent = Util.fixEmptyAndTrim((String)propertiesContent);
        this.debug = debug;
        this.downloadArtifacts = downloadArtifacts;
        this.labelRestriction = labelRestriction != null;
        this.enableConcurrentBuild = enableConcurrentBuild;
    }

    public String getIvyPath() {
        return this.ivyPath;
    }

    public String getIvySettingsPath() {
        return this.ivySettingsPath;
    }

    public String getPropertiesFilePath() {
        return this.propertiesFilePath;
    }

    public String getPropertiesContent() {
        return this.propertiesContent;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public boolean isDownloadArtifacts() {
        return this.downloadArtifacts;
    }

    public boolean isLabelRestriction() {
        return this.labelRestriction;
    }

    public boolean isEnableConcurrentBuild() {
        return this.enableConcurrentBuild;
    }

    public Collection<? extends Action> getProjectActions() {
        InternalIvyTriggerAction action = new InternalIvyTriggerAction(this.getDescriptor().getDisplayName());
        return Collections.singleton(action);
    }

    public boolean isContextOnStartupFetched() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IvyTriggerContext getContext(Node pollingNode, XTriggerLog log) throws XTriggerException {
        Map dependencies;
        block11: {
            FilePath ivySettingsFilePath;
            HashMap<String, String> envVars;
            log.info(String.format("Given job Ivy file value: %s", this.ivyPath));
            log.info(String.format("Given job Ivy settings file value: %s", this.ivySettingsPath));
            AbstractProject project = (AbstractProject)this.job;
            try {
                envVars = project != null ? EnvVarsResolver.getPollingEnvVars((Job)project, (Node)pollingNode) : new HashMap<String, String>();
            }
            catch (EnvInjectException e) {
                throw new XTriggerException((Throwable)e);
            }
            FilePathFactory filePathFactory = new FilePathFactory();
            FilePath ivyFilePath = filePathFactory.getDescriptorFilePath(this.ivyPath, project, pollingNode, log, envVars);
            URL ivySettingsUrl = IvyTrigger.getRemoteURL(this.ivySettingsPath, log);
            FilePath filePath = ivySettingsFilePath = ivySettingsUrl != null ? null : filePathFactory.getDescriptorFilePath(this.ivySettingsPath, project, pollingNode, log, envVars);
            if (ivyFilePath == null) {
                log.error("You have to provide a valid Ivy file.");
                return new IvyTriggerContext(null);
            }
            if (ivySettingsFilePath == null && ivySettingsUrl == null) {
                log.error("You have to provide a valid IvySettings file or URL.");
                return new IvyTriggerContext(null);
            }
            log.info(String.format("Resolved job Ivy file value: %s", ivyFilePath.getRemote()));
            log.info(String.format("Resolved job Ivy settings file value: %s", ivySettingsUrl == null ? ivySettingsFilePath.getRemote() : ivySettingsUrl.toString()));
            if (this.downloadArtifacts) {
                log.info("Artifacts in dependencies will be downloaded.");
            }
            PropertiesFileContentExtractor propertiesFileContentExtractor = new PropertiesFileContentExtractor(new FilePathFactory());
            String propertiesFileContent = propertiesFileContentExtractor.extractPropertiesFileContents(this.propertiesFilePath, project, pollingNode, log, envVars);
            String propertiesContentResolved = Util.replaceMacro((String)this.propertiesContent, envVars);
            dependencies = null;
            try {
                FilePath launcherFilePath = pollingNode.getRootPath();
                if (launcherFilePath == null) break block11;
                FilePath temporaryPropertiesFilePath = null;
                try {
                    temporaryPropertiesFilePath = launcherFilePath.createTextTempFile("props", "props", propertiesFileContent);
                    log.info("Temporary properties file path: " + temporaryPropertiesFilePath.getName());
                    dependencies = (Map)launcherFilePath.act((FilePath.FileCallable)new IvyTriggerEvaluator(((BuildableItem)this.job).getName(), ivyFilePath, ivySettingsFilePath, ivySettingsUrl, temporaryPropertiesFilePath, propertiesContentResolved, log, this.debug, this.downloadArtifacts, envVars));
                }
                finally {
                    if (temporaryPropertiesFilePath != null) {
                        temporaryPropertiesFilePath.delete();
                    }
                }
            }
            catch (IOException | InterruptedException e) {
                throw new XTriggerException((Throwable)e);
            }
        }
        return new IvyTriggerContext(dependencies);
    }

    private static URL getRemoteURL(String filename, XTriggerLog log) {
        URL settingsUrl;
        try {
            settingsUrl = new URL(filename);
        }
        catch (MalformedURLException e) {
            log.info("URL is not well-formatted. Assuming it is a local file: " + filename);
            return null;
        }
        String scheme = settingsUrl.getProtocol();
        if (scheme == null) {
            return null;
        }
        return settingsUrl;
    }

    protected String getName() {
        return "IvyTrigger";
    }

    protected Action[] getScheduledActions(Node pollingNode, XTriggerLog log) {
        return new Action[0];
    }

    protected boolean checkIfModified(IvyTriggerContext previousIvyTriggerContext, IvyTriggerContext newIvyTriggerContext, XTriggerLog log) throws XTriggerException {
        Map<String, IvyDependencyValue> previousDependencies = previousIvyTriggerContext.getDependencies();
        if (previousDependencies == null) {
            log.error("Can't compute files to check if there are modifications.");
            this.resetOldContext(previousIvyTriggerContext);
            return false;
        }
        Map<String, IvyDependencyValue> newComputedDependencies = newIvyTriggerContext.getDependencies();
        if (newComputedDependencies == null) {
            log.error("Can't record the resolved dependencies graph.");
            this.resetOldContext(previousIvyTriggerContext);
            return false;
        }
        if (newComputedDependencies.size() == 0) {
            log.error("Can't record any dependencies. Check your settings.");
            this.resetOldContext(previousIvyTriggerContext);
            return false;
        }
        for (Map.Entry<String, IvyDependencyValue> dependency : newComputedDependencies.entrySet()) {
            log.info(String.format("Resolved dependency %s ...", dependency.getKey()));
        }
        if (previousDependencies.size() != newComputedDependencies.size()) {
            log.info("\nThe number of resolved dependencies has changed.");
            this.setNewContext(newIvyTriggerContext);
            return true;
        }
        log.info("\nChecking comparison to previous recorded dependencies.");
        for (Map.Entry<String, IvyDependencyValue> dependency : previousDependencies.entrySet()) {
            if (!this.isDependencyChanged(log, dependency, newComputedDependencies)) continue;
            this.setNewContext(newIvyTriggerContext);
            return true;
        }
        this.setNewContext(newIvyTriggerContext);
        return false;
    }

    private boolean isDependencyChanged(XTriggerLog log, Map.Entry<String, IvyDependencyValue> previousDependency, Map<String, IvyDependencyValue> newComputedDependencies) {
        String dependencyId = previousDependency.getKey();
        log.info(String.format("Checking previous recording dependency %s", dependencyId));
        IvyDependencyValue previousDependencyValue = previousDependency.getValue();
        IvyDependencyValue newDependencyValue = newComputedDependencies.get(dependencyId);
        if (newDependencyValue == null) {
            log.info(String.format("....The previous dependency %s doesn't exist anymore.", dependencyId));
            return true;
        }
        String previousRevision = previousDependencyValue.getRevision();
        String newRevision = newDependencyValue.getRevision();
        if (!newRevision.equals(previousRevision)) {
            log.info("....The dependency version has changed.");
            log.info(String.format("....The previous version recorded was %s.", previousRevision));
            log.info(String.format("....The new computed version is %s.", newRevision));
            return true;
        }
        List<IvyArtifactValue> previousArtifactValueList = previousDependencyValue.getArtifacts();
        List<IvyArtifactValue> newArtifactValueList = newDependencyValue.getArtifacts();
        for (IvyArtifactValue artifactValue : newArtifactValueList) {
            log.info(String.format("..Dependency resolved artifact: %s", artifactValue.getFullName()));
        }
        if (previousArtifactValueList.size() != newArtifactValueList.size()) {
            log.info("....The number of artifacts of the dependency has changed.");
        }
        if (this.downloadArtifacts) {
            log.info("...Checking comparison to previous recorded artifacts.");
            for (IvyArtifactValue ivyArtifactValue : previousArtifactValueList) {
                if (!this.isArtifactsChanged(log, ivyArtifactValue, newArtifactValueList)) continue;
                return true;
            }
        } else {
            log.info("...Artifacts were not configured for download, no individual artifact checks made.");
        }
        return false;
    }

    private boolean isArtifactsChanged(XTriggerLog log, IvyArtifactValue previousIvyArtifactValue, List<IvyArtifactValue> newArtifactValueList) {
        long newPublicationDate;
        log.info(String.format("....Checking previous recording artifact %s", previousIvyArtifactValue.getFullName()));
        IvyArtifactValue newIvyArtifactValue = null;
        boolean stop = false;
        for (int i = 0; !stop && i < newArtifactValueList.size(); ++i) {
            IvyArtifactValue ivyArtifactValue = newArtifactValueList.get(i);
            if (!ivyArtifactValue.getFullName().equals(previousIvyArtifactValue.getFullName())) continue;
            newIvyArtifactValue = ivyArtifactValue;
            stop = true;
        }
        if (newIvyArtifactValue == null) {
            log.info(String.format("....The previous artifact %s doesn't exist anymore.", previousIvyArtifactValue.getFullName()));
            return true;
        }
        long previousPublicationDate = previousIvyArtifactValue.getLastModificationDate();
        if (previousPublicationDate != (newPublicationDate = newIvyArtifactValue.getLastModificationDate())) {
            log.info("....The artifact version of the dependency has changed.");
            log.info(String.format("....The previous publication date recorded was %s.", new Date(previousPublicationDate)));
            log.info(String.format("....The new computed publication date is %s.", new Date(newPublicationDate)));
            return true;
        }
        log.info(String.format("....No changes for the %s artifact", newIvyArtifactValue.getFullName()));
        return false;
    }

    protected File getLogFile() {
        if (this.job != null) {
            return new File(((BuildableItem)this.job).getRootDir(), "ivy-polling.log");
        }
        return null;
    }

    protected boolean requiresWorkspaceForPolling() {
        return true;
    }

    public String getCause() {
        return "Ivy Dependency trigger";
    }

    public final class InternalIvyTriggerAction
    extends IvyTriggerAction {
        private final transient String label;

        public InternalIvyTriggerAction(String label) {
            this.label = label;
        }

        public AbstractProject<?, ?> getOwner() {
            return (AbstractProject)IvyTrigger.this.job;
        }

        public String getIconFileName() {
            return "clipboard.gif";
        }

        public String getDisplayName() {
            return "IvyTrigger Log";
        }

        public String getUrlName() {
            return "ivyTriggerPollLog";
        }

        public String getLabel() {
            return this.label;
        }

        public String getLog() throws IOException {
            return Util.loadFile((File)IvyTrigger.this.getLogFile());
        }

        @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED"})
        public void writeLogTo(XMLOutput out) throws IOException {
            new AnnotatedLargeText(IvyTrigger.this.getLogFile(), Charset.defaultCharset(), true, (Object)this).writeHtmlTo(0L, out.asWriter());
        }
    }

    @Extension
    public static class IvyScriptTriggerDescriptor
    extends XTriggerDescriptor {
        public String getHelpFile() {
            return "/plugin/ivytrigger/help.html";
        }

        public String getDisplayName() {
            return "IvyTrigger - Poll with an Ivy script";
        }
    }
}

