/*
 * Decompiled with CFR 0.152.
 */
package hudson.ivy;

import hudson.ivy.ModuleName;
import java.io.Serializable;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;

public final class ModuleDependency
implements Serializable {
    public final String organisation;
    public final String name;
    public final String revision;
    public final String branch;
    public static final String UNKNOWN = "*";
    private static final long serialVersionUID = 1L;

    public ModuleDependency(String organisation, String name, String revision, String branch) {
        this.organisation = organisation;
        this.name = name;
        this.revision = revision == null || revision.startsWith("latest.") || revision.startsWith("working@") || revision.contains("${") ? UNKNOWN : revision;
        this.branch = branch == null || branch.contains("${") ? UNKNOWN : branch;
    }

    public ModuleDependency(ModuleName name, String revision, String branch) {
        this(name.organisation, name.name, revision, branch);
    }

    public ModuleDependency(DependencyDescriptor dep) {
        this(dep.getDependencyRevisionId().getOrganisation(), dep.getDependencyRevisionId().getName(), dep.getDependencyRevisionId().getRevision(), dep.getDependencyRevisionId().getBranch());
    }

    public ModuleDependency(ModuleDescriptor module) {
        this(module.getModuleRevisionId().getOrganisation(), module.getModuleRevisionId().getName(), module.getModuleRevisionId().getRevision(), module.getModuleRevisionId().getBranch());
    }

    public ModuleName getName() {
        return new ModuleName(this.organisation, this.name);
    }

    public ModuleDependency withUnknownRevision() {
        return new ModuleDependency(this.organisation, this.name, UNKNOWN, this.branch);
    }

    public ModuleDependency withUnknownRevisionAndBranch() {
        return new ModuleDependency(this.organisation, this.name, UNKNOWN, UNKNOWN);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ModuleDependency that = (ModuleDependency)o;
        return this.name.equals(that.name) && this.organisation.equals(that.organisation) && this.revision.equals(that.revision) && this.branch.equals(that.branch);
    }

    public int hashCode() {
        int result = this.organisation.hashCode();
        result = 31 * result + this.name.hashCode();
        result = 31 * result + this.revision.hashCode();
        result = 31 * result + this.branch.hashCode();
        return result;
    }
}

