/*
 * Decompiled with CFR 0.152.
 */
package hudson.ivy;

import hudson.ivy.ModuleDependency;
import hudson.ivy.ModuleName;
import java.io.Serializable;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ModuleRevisionId;

final class IvyModuleInfo
implements Serializable {
    public final ModuleName name;
    public final String displayName;
    public final String relativePathToDescriptor;
    public final String revision;
    public final String branch;
    public final Set<ModuleDependency> dependencies = new LinkedHashSet<ModuleDependency>();
    private static final long serialVersionUID = 1L;

    public IvyModuleInfo(ModuleDescriptor module, String relativePathToDescriptor) {
        this.name = new ModuleName(module);
        ModuleRevisionId mrid = module.getModuleRevisionId();
        this.revision = mrid.getRevision() == null || mrid.getRevision().startsWith("working@") || mrid.getRevision().contains("${") ? "*" : mrid.getRevision();
        this.branch = mrid.getBranch() == null || mrid.getBranch().contains("${") ? "*" : mrid.getBranch();
        this.displayName = mrid.getName();
        this.relativePathToDescriptor = relativePathToDescriptor;
        for (DependencyDescriptor dep : module.getDependencies()) {
            this.dependencies.add(new ModuleDependency(dep));
        }
    }
}

