/*
 * Decompiled with CFR 0.152.
 */
package jenkinsci.plugins.influxdb.generators;

import com.influxdb.client.domain.WritePrecision;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.PerfPublisher.PerfPublisherBuildAction;
import hudson.plugins.PerfPublisher.Report.Metric;
import hudson.plugins.PerfPublisher.Report.ReportContainer;
import hudson.plugins.PerfPublisher.Report.Test;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import jenkinsci.plugins.influxdb.generators.AbstractPointGenerator;
import jenkinsci.plugins.influxdb.generators.TimeGenerator;
import jenkinsci.plugins.influxdb.models.AbstractPoint;
import jenkinsci.plugins.influxdb.renderer.ProjectNameRenderer;

public class PerfPublisherPointGenerator
extends AbstractPointGenerator {
    private final String customPrefix;
    private final PerfPublisherBuildAction performanceBuildAction;
    private final TimeGenerator timeGenerator;

    public PerfPublisherPointGenerator(Run<?, ?> build, TaskListener listener, ProjectNameRenderer projectNameRenderer, long timestamp, String jenkinsEnvParameterTag, String customPrefix) {
        super(build, listener, projectNameRenderer, timestamp, jenkinsEnvParameterTag);
        this.customPrefix = customPrefix;
        this.performanceBuildAction = (PerfPublisherBuildAction)build.getAction(PerfPublisherBuildAction.class);
        this.timeGenerator = new TimeGenerator(timestamp);
    }

    @Override
    public boolean hasReport() {
        return this.performanceBuildAction != null && this.performanceBuildAction.getReport() != null;
    }

    @Override
    public AbstractPoint buildPoint(String name, String customPrefix, Run<?, ?> build) {
        return super.buildPoint(name, customPrefix, build).time(this.timeGenerator.next(), WritePrecision.NS);
    }

    @Override
    public AbstractPoint[] generate() {
        ReportContainer reports = this.performanceBuildAction.getReports();
        ArrayList<AbstractPoint> points = new ArrayList<AbstractPoint>();
        points.add(this.generateSummaryPoint(reports));
        points.addAll(this.generateMetricsPoints(reports));
        for (Test test : reports.getTests()) {
            points.add(this.generateTestPoint(test));
            points.addAll(this.generateTestMetricsPoints(test));
        }
        return points.toArray(new AbstractPoint[0]);
    }

    private AbstractPoint generateSummaryPoint(ReportContainer reports) {
        AbstractPoint point = this.buildPoint("perfpublisher_summary", this.customPrefix, this.build).addField("number_of_tests", reports.getNumberOfTest()).addField("number_of_executed_tests", reports.getNumberOfExecutedTest()).addField("number_of_not_executed_tests", reports.getNumberOfNotExecutedTest()).addField("number_of_passed_tests", reports.getNumberOfPassedTest()).addField("number_of_failed_tests", reports.getNumberOfFailedTest()).addField("number_of_success_tests", reports.getNumberOfSuccessTests()).addField("number_of_true_false_tests", reports.getNumberOfTrueFalseTest());
        if (reports.getBestCompileTimeTest().isCompileTime()) {
            point.addField("best_compile_time_test_value", reports.getBestCompileTimeTestValue()).addField("best_compile_time_test_name", reports.getBestCompileTimeTestName()).addField("worst_compile_time_test_value", reports.getWorstCompileTimeTestValue()).addField("worst_compile_time_test_name", reports.getWorstCompileTimeTestName()).addField("avg_compile_time", reports.getAverageOfCompileTime());
        }
        if (reports.getBestPerformanceTest().isPerformance()) {
            point.addField("best_performance_test_value", reports.getBestPerformanceTestValue()).addField("best_performance_test_name", reports.getBestPerformanceTestName()).addField("worst_performance_test_value", reports.getWorstPerformanceTestValue()).addField("worst_performance_test_name", reports.getWorstPerformanceTestName()).addField("average_performance", reports.getAverageOfPerformance());
        }
        if (reports.getBestExecutionTimeTest().isExecutionTime()) {
            point.addField("best_execution_time_test_value", reports.getBestExecutionTimeTestValue()).addField("best_execution_time_test_name", reports.getBestExecutionTimeTestName()).addField("worst_execution_time_test_value", reports.getWorstExecutionTimeTestValue()).addField("worst_execution_time_test_name", reports.getWorstExecutionTimeTestName()).addField("avg_execution_time", reports.getAverageOfExecutionTime());
        }
        return point;
    }

    private List<AbstractPoint> generateMetricsPoints(ReportContainer reports) {
        ArrayList<AbstractPoint> points = new ArrayList<AbstractPoint>();
        for (Map.Entry entry : reports.getAverageValuePerMetrics().entrySet()) {
            String metricName = (String)entry.getKey();
            AbstractPoint point = this.buildPoint("perfpublisher_metric", this.customPrefix, this.build).addField("metric_name", metricName).addField("average", (Number)entry.getValue()).addField("worst", (Number)reports.getWorstValuePerMetrics().get(metricName)).addField("best", (Number)reports.getBestValuePerMetrics().get(metricName));
            points.add(point);
        }
        return points;
    }

    private AbstractPoint generateTestPoint(Test test) {
        AbstractPoint point = this.buildPoint("perfpublisher_test", this.customPrefix, this.build).addField("test_name", test.getName()).addField("successful", test.isSuccessfull()).addField("executed", test.isExecuted());
        if (test.getMessage() != null) {
            point.addField("message", test.getMessage());
        }
        if (test.isCompileTime()) {
            point.addField("compile_time", test.getCompileTime().getMeasure());
        }
        if (test.isExecutionTime()) {
            point.addField("execution_time", test.getExecutionTime().getMeasure());
        }
        if (test.isPerformance()) {
            point.addField("performance", test.getPerformance().getMeasure());
        }
        return point;
    }

    private List<AbstractPoint> generateTestMetricsPoints(Test test) {
        ArrayList<AbstractPoint> points = new ArrayList<AbstractPoint>();
        for (Map.Entry entry : test.getMetrics().entrySet()) {
            String metricName = (String)entry.getKey();
            Metric metric = (Metric)entry.getValue();
            AbstractPoint point = this.buildPoint("perfpublisher_test_metric", this.customPrefix, this.build).addField("test_name", test.getName()).addField("metric_name", metricName).addField("value", metric.getMeasure()).addField("unit", metric.getUnit()).addField("relevant", metric.isRelevant());
            points.add(point);
        }
        return points;
    }
}

