/*
 * Decompiled with CFR 0.152.
 */
package jenkinsci.plugins.influxdb.generators;

import hudson.model.Run;
import hudson.model.TaskListener;
import java.util.Map;
import jenkinsci.plugins.influxdb.generators.AbstractPointGenerator;
import jenkinsci.plugins.influxdb.models.AbstractPoint;
import jenkinsci.plugins.influxdb.renderer.ProjectNameRenderer;

public class CustomDataPointGenerator
extends AbstractPointGenerator {
    private static final String BUILD_TIME = "build_time";
    private final String customPrefix;
    private final String measurementName;
    private final Map<String, Object> customData;
    private final Map<String, String> customDataTags;

    public CustomDataPointGenerator(Run<?, ?> build, TaskListener listener, ProjectNameRenderer projectNameRenderer, long timestamp, String jenkinsEnvParameterTag, String customPrefix, Map<String, Object> customData, Map<String, String> customDataTags, String measurementName) {
        super(build, listener, projectNameRenderer, timestamp, jenkinsEnvParameterTag);
        this.customPrefix = customPrefix;
        this.customData = customData;
        this.customDataTags = customDataTags;
        this.measurementName = "jenkins_data".equals(measurementName) ? "jenkins_custom_data" : "custom_" + measurementName;
    }

    @Override
    public boolean hasReport() {
        return this.customData != null && !this.customData.isEmpty();
    }

    @Override
    public AbstractPoint[] generate() {
        long startTime = this.build.getTimeInMillis();
        long currTime = System.currentTimeMillis();
        long dt = currTime - startTime;
        AbstractPoint point = this.buildPoint(this.measurementName, this.customPrefix, this.build).addField(BUILD_TIME, this.build.getDuration() == 0L ? dt : this.build.getDuration()).addFields(this.customData);
        if (this.customDataTags != null && !this.customDataTags.isEmpty()) {
            point.addTags(this.customDataTags);
        }
        return new AbstractPoint[]{point};
    }
}

