/*
 * Decompiled with CFR 0.152.
 */
package jenkinsci.plugins.influxdb;

import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import hudson.EnvVars;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import jenkinsci.plugins.influxdb.InfluxReportException;
import jenkinsci.plugins.influxdb.generators.AgentPointGenerator;
import jenkinsci.plugins.influxdb.generators.ChangeLogPointGenerator;
import jenkinsci.plugins.influxdb.generators.CoberturaPointGenerator;
import jenkinsci.plugins.influxdb.generators.CoveragePointGenerator;
import jenkinsci.plugins.influxdb.generators.CustomDataMapPointGenerator;
import jenkinsci.plugins.influxdb.generators.CustomDataPointGenerator;
import jenkinsci.plugins.influxdb.generators.GitPointGenerator;
import jenkinsci.plugins.influxdb.generators.JUnitPointGenerator;
import jenkinsci.plugins.influxdb.generators.JacocoPointGenerator;
import jenkinsci.plugins.influxdb.generators.JenkinsBasePointGenerator;
import jenkinsci.plugins.influxdb.generators.MetricsPointGenerator;
import jenkinsci.plugins.influxdb.generators.PerfPublisherPointGenerator;
import jenkinsci.plugins.influxdb.generators.PerformancePointGenerator;
import jenkinsci.plugins.influxdb.generators.PointGenerator;
import jenkinsci.plugins.influxdb.generators.RobotFrameworkPointGenerator;
import jenkinsci.plugins.influxdb.generators.SonarQubePointGenerator;
import jenkinsci.plugins.influxdb.generators.serenity.SerenityJsonSummaryFile;
import jenkinsci.plugins.influxdb.generators.serenity.SerenityPointGenerator;
import jenkinsci.plugins.influxdb.models.AbstractPoint;
import jenkinsci.plugins.influxdb.models.InfluxDBClientWrapper;
import jenkinsci.plugins.influxdb.models.Target;
import jenkinsci.plugins.influxdb.renderer.ProjectNameRenderer;
import org.jenkinsci.plugins.plaincredentials.StringCredentials;

public class InfluxDbPublicationService {
    private static final Logger logger = Logger.getLogger(InfluxDbPublicationService.class.getName());
    private final List<Target> selectedTargets;
    private final String customProjectName;
    private final String customPrefix;
    private final Map<String, Object> customData;
    private final Map<String, String> customDataTags;
    private final Map<String, Map<String, Object>> customDataMap;
    private final Map<String, Map<String, String>> customDataMapTags;
    private final String jenkinsEnvParameterField;
    private final String jenkinsEnvParameterTag;
    private final String measurementName;
    private final long timestamp;

    public InfluxDbPublicationService(List<Target> selectedTargets, String customProjectName, String customPrefix, Map<String, Object> customData, Map<String, String> customDataTags, Map<String, Map<String, String>> customDataMapTags, Map<String, Map<String, Object>> customDataMap, long timestamp, String jenkinsEnvParameterField, String jenkinsEnvParameterTag, String measurementName) {
        this.selectedTargets = selectedTargets;
        this.customProjectName = customProjectName;
        this.customPrefix = customPrefix;
        this.customData = customData;
        this.customDataTags = customDataTags;
        this.customDataMap = customDataMap;
        this.customDataMapTags = customDataMapTags;
        this.timestamp = timestamp;
        this.jenkinsEnvParameterField = jenkinsEnvParameterField;
        this.jenkinsEnvParameterTag = jenkinsEnvParameterTag;
        this.measurementName = measurementName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void perform(Run<?, ?> build, TaskListener listener, EnvVars env) {
        listener.getLogger().println("[InfluxDB Plugin] Collecting data...");
        ProjectNameRenderer measurementRenderer = new ProjectNameRenderer(this.customPrefix, this.customProjectName);
        ArrayList<AbstractPoint> pointsToWrite = new ArrayList<AbstractPoint>();
        JenkinsBasePointGenerator jGen = new JenkinsBasePointGenerator(build, listener, measurementRenderer, this.timestamp, this.jenkinsEnvParameterTag, this.jenkinsEnvParameterField, this.customPrefix, this.measurementName, env);
        this.addPoints(pointsToWrite, jGen, listener);
        AgentPointGenerator agentGen = new AgentPointGenerator(build, listener, measurementRenderer, this.timestamp, this.jenkinsEnvParameterTag, this.customPrefix);
        this.addPointsFromPlugin(pointsToWrite, agentGen, listener, "Custom Data");
        CustomDataPointGenerator cdGen = new CustomDataPointGenerator(build, listener, measurementRenderer, this.timestamp, this.jenkinsEnvParameterTag, this.customPrefix, this.customData, this.customDataTags, this.measurementName);
        this.addPointsFromPlugin(pointsToWrite, cdGen, listener, "Custom Data");
        CustomDataMapPointGenerator cdmGen = new CustomDataMapPointGenerator(build, listener, measurementRenderer, this.timestamp, this.jenkinsEnvParameterTag, this.customPrefix, this.customDataMap, this.customDataMapTags);
        this.addPointsFromPlugin(pointsToWrite, cdmGen, listener, "Custom Data Map");
        try {
            CoberturaPointGenerator cGen = new CoberturaPointGenerator(build, listener, measurementRenderer, this.timestamp, this.jenkinsEnvParameterTag, this.customPrefix);
            this.addPointsFromPlugin(pointsToWrite, cGen, listener, "Cobertura");
        }
        catch (NoClassDefFoundError ignore) {
            logger.fine("Plugin skipped: Cobertura");
        }
        try {
            RobotFrameworkPointGenerator rfGen = new RobotFrameworkPointGenerator(build, listener, measurementRenderer, this.timestamp, this.jenkinsEnvParameterTag, this.customPrefix);
            this.addPointsFromPlugin(pointsToWrite, rfGen, listener, "Robot Framework");
        }
        catch (NoClassDefFoundError ignore) {
            logger.fine("Plugin skipped: Robot Framework");
        }
        try {
            JacocoPointGenerator jacoGen = new JacocoPointGenerator(build, listener, measurementRenderer, this.timestamp, this.jenkinsEnvParameterTag, this.customPrefix);
            this.addPointsFromPlugin(pointsToWrite, jacoGen, listener, "JaCoCo");
        }
        catch (NoClassDefFoundError ignore) {
            logger.fine("Plugin skipped: JaCoCo");
        }
        try {
            PerformancePointGenerator perfGen = new PerformancePointGenerator(build, listener, measurementRenderer, this.timestamp, this.jenkinsEnvParameterTag, this.customPrefix);
            this.addPointsFromPlugin(pointsToWrite, perfGen, listener, "Performance");
        }
        catch (NoClassDefFoundError ignore) {
            logger.fine("Plugin skipped: Performance");
        }
        try {
            GitPointGenerator gitGen = new GitPointGenerator(build, listener, measurementRenderer, this.timestamp, this.jenkinsEnvParameterTag, this.customPrefix);
            this.addPointsFromPlugin(pointsToWrite, gitGen, listener, "Git");
        }
        catch (NoClassDefFoundError ignore) {
            logger.fine("Plugin skipped: Git");
        }
        JUnitPointGenerator junitGen = new JUnitPointGenerator(build, listener, measurementRenderer, this.timestamp, this.jenkinsEnvParameterTag, this.customPrefix, env);
        this.addPointsFromPlugin(pointsToWrite, junitGen, listener, "JUnit");
        SonarQubePointGenerator sonarGen = new SonarQubePointGenerator(build, listener, measurementRenderer, this.timestamp, this.jenkinsEnvParameterTag, this.customPrefix, env);
        this.addPointsFromPlugin(pointsToWrite, sonarGen, listener, "SonarQube");
        SerenityJsonSummaryFile serenityJsonSummaryFile = new SerenityJsonSummaryFile((String)env.get((Object)"WORKSPACE"));
        SerenityPointGenerator serenityGen = new SerenityPointGenerator(build, listener, measurementRenderer, this.timestamp, this.jenkinsEnvParameterTag, this.customPrefix, serenityJsonSummaryFile);
        this.addPointsFromPlugin(pointsToWrite, serenityGen, listener, "Serenity");
        ChangeLogPointGenerator changeLogGen = new ChangeLogPointGenerator(build, listener, measurementRenderer, this.timestamp, this.jenkinsEnvParameterTag, this.customPrefix);
        this.addPointsFromPlugin(pointsToWrite, changeLogGen, listener, "Change log");
        try {
            PerfPublisherPointGenerator perfPublisherGen = new PerfPublisherPointGenerator(build, listener, measurementRenderer, this.timestamp, this.jenkinsEnvParameterTag, this.customPrefix);
            this.addPointsFromPlugin(pointsToWrite, perfPublisherGen, listener, "Performance Publisher");
        }
        catch (NoClassDefFoundError ignore) {
            logger.fine("Plugin skipped: Performance Publisher");
        }
        try {
            MetricsPointGenerator metricsGen = new MetricsPointGenerator(build, listener, measurementRenderer, this.timestamp, this.jenkinsEnvParameterTag, this.customPrefix);
            this.addPointsFromPlugin(pointsToWrite, metricsGen, listener, "Metrics");
        }
        catch (NoClassDefFoundError ignore) {
            logger.fine("Plugin skipped: Metrics");
        }
        try {
            CoveragePointGenerator coverageGen = new CoveragePointGenerator(build, listener, measurementRenderer, this.timestamp, this.jenkinsEnvParameterTag, this.customPrefix);
            this.addPointsFromPlugin(pointsToWrite, coverageGen, listener, "Coverage");
        }
        catch (NoClassDefFoundError ignore) {
            logger.fine("Plugin skipped: Coverage");
        }
        for (Target target : this.selectedTargets) {
            try {
                new URL(target.getUrl());
            }
            catch (MalformedURLException e) {
                String logMessage = String.format("[InfluxDB Plugin] Skipping target '%s' due to invalid URL '%s'", target.getDescription(), target.getUrl());
                logger.warning(logMessage);
                listener.getLogger().println(logMessage);
                continue;
            }
            String logMessage = String.format("[InfluxDB Plugin] Publishing data to target '%s' (url='%s', database='%s')", target.getDescription(), target.getUrl(), target.getDatabase());
            logger.fine(logMessage);
            listener.getLogger().println(logMessage);
            InfluxDBClientWrapper influxDB = null;
            try {
                StandardUsernamePasswordCredentials basicAuthCredentials = (StandardUsernamePasswordCredentials)CredentialsProvider.findCredentialById((String)target.getCredentialsId(), StandardUsernamePasswordCredentials.class, build);
                StringCredentials tokenCredentials = (StringCredentials)CredentialsProvider.findCredentialById((String)target.getCredentialsId(), StringCredentials.class, build);
                influxDB = new InfluxDBClientWrapper(target.getUrl(), target.getOrganization(), target.getDatabase(), target.getRetentionPolicy(), basicAuthCredentials, tokenCredentials, target.isUsingJenkinsProxy());
                influxDB.writePoints(pointsToWrite);
            }
            catch (Exception e) {
                if (target.isExposeExceptions()) {
                    throw new InfluxReportException(e);
                }
                logger.log(Level.WARNING, "Could not report to InfluxDB. Ignoring Exception.", e);
            }
            finally {
                if (influxDB == null) continue;
                influxDB.close();
            }
        }
        listener.getLogger().println("[InfluxDB Plugin] Completed.");
    }

    private void addPointsFromPlugin(List<AbstractPoint> pointsToWrite, PointGenerator generator, TaskListener listener, String plugin) {
        if (generator.hasReport()) {
            listener.getLogger().println("[InfluxDB plugin] " + plugin + " plugin data found. Writing to InfluxDB...");
            this.addPoints(pointsToWrite, generator, listener);
        } else {
            logger.fine("Data not found: " + plugin);
        }
    }

    private void addPoints(List<AbstractPoint> pointsToWrite, PointGenerator generator, TaskListener listener) {
        try {
            pointsToWrite.addAll(Arrays.stream(generator.generate()).filter(Objects::nonNull).collect(Collectors.toList()));
        }
        catch (Exception e) {
            listener.getLogger().println("[InfluxDB Plugin] Failed to collect data. Ignoring Exception:" + e);
        }
    }
}

