/*
 * Decompiled with CFR 0.152.
 */
package jenkinsci.plugins.influxdb.models;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.cloudbees.plugins.credentials.domains.URIRequirementBuilder;
import hudson.Extension;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.security.ACL;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.Serializable;
import java.util.List;
import jenkins.model.Jenkins;
import jenkinsci.plugins.influxdb.models.InfluxDBClientWrapper;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.jenkinsci.plugins.plaincredentials.StringCredentials;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.verb.POST;
import org.springframework.security.core.Authentication;

public class Target
extends AbstractDescribableImpl<Target>
implements Serializable {
    private String description;
    private String url;
    private String credentialsId;
    private String database;
    private String organization;
    private String retentionPolicy;
    private boolean jobScheduledTimeAsPointsTimestamp;
    private boolean exposeExceptions;
    private boolean usingJenkinsProxy;
    private boolean globalListener;
    private String globalListenerFilter;

    public Target() {
    }

    @DataBoundConstructor
    public Target(String description, String url, String credentialsId, String organization, String database, String retentionPolicy, boolean jobScheduledTimeAsPointsTimestamp, boolean exposeExceptions, boolean usingJenkinsProxy, boolean globalListener, String globalListenerFilter) {
        this.description = description;
        this.url = url;
        this.credentialsId = credentialsId;
        this.organization = organization;
        this.database = database;
        this.retentionPolicy = retentionPolicy;
        this.jobScheduledTimeAsPointsTimestamp = jobScheduledTimeAsPointsTimestamp;
        this.exposeExceptions = exposeExceptions;
        this.usingJenkinsProxy = usingJenkinsProxy;
        this.globalListener = globalListener;
        this.globalListenerFilter = globalListenerFilter;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getCredentialsId() {
        return this.credentialsId;
    }

    public void setCredentialsId(String credentialsId) {
        this.credentialsId = credentialsId;
    }

    public String getOrganization() {
        return this.organization;
    }

    public void setOrganization(String organization) {
        this.organization = organization;
    }

    public String getDatabase() {
        return this.database;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public String getRetentionPolicy() {
        return this.retentionPolicy;
    }

    public void setRetentionPolicy(String retentionPolicy) {
        this.retentionPolicy = retentionPolicy;
    }

    public boolean isJobScheduledTimeAsPointsTimestamp() {
        return this.jobScheduledTimeAsPointsTimestamp;
    }

    public void setJobScheduledTimeAsPointsTimestamp(boolean jobScheduledTimeAsPointsTimestamp) {
        this.jobScheduledTimeAsPointsTimestamp = jobScheduledTimeAsPointsTimestamp;
    }

    public boolean isExposeExceptions() {
        return this.exposeExceptions;
    }

    public void setExposeExceptions(boolean exposeExceptions) {
        this.exposeExceptions = exposeExceptions;
    }

    public boolean isUsingJenkinsProxy() {
        return this.usingJenkinsProxy;
    }

    public void setUsingJenkinsProxy(boolean usingJenkinsProxy) {
        this.usingJenkinsProxy = usingJenkinsProxy;
    }

    public boolean isGlobalListener() {
        return this.globalListener;
    }

    public void setGlobalListener(boolean globalListener) {
        this.globalListener = globalListener;
    }

    public String getGlobalListenerFilter() {
        return this.globalListenerFilter;
    }

    public void setGlobalListenerFilter(String globalListenerFilter) {
        this.globalListenerFilter = globalListenerFilter;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("description", (Object)this.description).append("url", (Object)this.url).append("credentialsId", (Object)this.credentialsId).append("database", (Object)this.database).append("organization", (Object)this.organization).toString();
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<Target> {
        public static StandardUsernamePasswordCredentials getUsernamePasswordCredentials(String credentialsId, String url, @AncestorInPath Item context) {
            List lookupCredentials = CredentialsProvider.lookupCredentialsInItem(StandardUsernamePasswordCredentials.class, (Item)context, (Authentication)ACL.SYSTEM2, (List)URIRequirementBuilder.fromUri((String)url).build());
            return (StandardUsernamePasswordCredentials)CredentialsMatchers.firstOrNull((Iterable)lookupCredentials, (CredentialsMatcher)CredentialsMatchers.withId((String)(null == credentialsId ? "" : credentialsId)));
        }

        public static StringCredentials getTokenCredentials(String url, String credentialsId, @AncestorInPath Item context) {
            List lookupTokenCredentials = CredentialsProvider.lookupCredentialsInItem(StringCredentials.class, (Item)context, (Authentication)ACL.SYSTEM2, (List)URIRequirementBuilder.fromUri((String)url).build());
            return (StringCredentials)CredentialsMatchers.firstOrNull((Iterable)lookupTokenCredentials, (CredentialsMatcher)CredentialsMatchers.withId((String)(null == credentialsId ? "" : credentialsId)));
        }

        public ListBoxModel doFillCredentialsIdItems(@QueryParameter String url, @QueryParameter String credentialsId) {
            if (!Jenkins.get().hasPermission(Jenkins.ADMINISTER)) {
                return new StandardListBoxModel().includeCurrentValue(credentialsId);
            }
            return new StandardListBoxModel().includeEmptyValue().includeAs(ACL.SYSTEM, (ItemGroup)Jenkins.get(), StandardUsernamePasswordCredentials.class, URIRequirementBuilder.fromUri((String)url).build()).includeAs(ACL.SYSTEM, (ItemGroup)Jenkins.get(), StandardCredentials.class, URIRequirementBuilder.fromUri((String)url).build()).includeCurrentValue(credentialsId);
        }

        public FormValidation doCheckDescription(@QueryParameter String value) {
            return FormValidation.validateRequired((String)value);
        }

        public FormValidation doCheckUrl(@QueryParameter String value) {
            return FormValidation.validateRequired((String)value);
        }

        public FormValidation doCheckDatabase(@QueryParameter String value) {
            return FormValidation.validateRequired((String)value);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @POST
        public FormValidation doVerifyConnection(@QueryParameter String url, @QueryParameter String credentialsId, @QueryParameter String organization, @QueryParameter String database, @QueryParameter String retentionPolicy, @QueryParameter boolean usingJenkinsProxy, @AncestorInPath Item context) {
            try (InfluxDBClientWrapper client = null;){
                this.doCheckUrl(url);
                this.doCheckDatabase(database);
                Jenkins.get().checkPermission(Jenkins.ADMINISTER);
                StandardUsernamePasswordCredentials basicAuthCredentials = DescriptorImpl.getUsernamePasswordCredentials(credentialsId, url, context);
                StringCredentials tokenCredentials = DescriptorImpl.getTokenCredentials(url, credentialsId, context);
                client = new InfluxDBClientWrapper(url, organization, database, retentionPolicy, basicAuthCredentials, tokenCredentials, usingJenkinsProxy);
                String connectedApi = client.getConnectedApiVersion();
                String serverVersion = client.getAPIVersion();
                FormValidation formValidation = FormValidation.ok((String)("Connection success using " + connectedApi + " API (server version: " + serverVersion + ")"));
                return formValidation;
            }
        }
    }
}

