/*
 * Decompiled with CFR 0.152.
 */
package jenkinsci.plugins.influxdb.generators;

import hudson.EnvVars;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import jenkinsci.plugins.influxdb.generators.AbstractPointGenerator;
import jenkinsci.plugins.influxdb.models.AbstractPoint;
import jenkinsci.plugins.influxdb.renderer.ProjectNameRenderer;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import okhttp3.Credentials;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.apache.commons.lang3.StringUtils;

public class SonarQubePointGenerator
extends AbstractPointGenerator {
    private static final String BUILD_DISPLAY_NAME = "display_name";
    private static final String SONARQUBE_LINES_OF_CODE = "lines_of_code";
    private static final String SONARQUBE_COMPLEXITY = "complexity";
    private static final String SONARQUBE_CRITICAL_ISSUES = "critical_issues";
    private static final String SONARQUBE_MAJOR_ISSUES = "major_issues";
    private static final String SONARQUBE_MINOR_ISSUES = "minor_issues";
    private static final String SONARQUBE_INFO_ISSUES = "info_issues";
    private static final String SONARQUBE_BLOCKER_ISSUES = "blocker_issues";
    private static final String SONARQUBE_CODE_SMELLS = "code_smells";
    private static final String SONARQUBE_BUGS = "bugs";
    private static final String SONARQUBE_COVERAGE = "coverage";
    private static final String SONARQUBE_VULNERABILITIES = "vulnerabilities";
    private static final String SONARQUBE_BRANCH_COVERAGE = "branch_coverage";
    private static final String SONARQUBE_LINE_COVERAGE = "line_coverage";
    private static final String SONARQUBE_LINES_TO_COVER = "lines_to_cover";
    private static final String SONARQUBE_ALERT_STATUS = "alert_status";
    private static final String SONARQUBE_QUALITY_GATE_DETAILS = "quality_gate_details";
    private static final String SONARQUBE_DUPLICATED_LINES_DENSITY = "duplicated_lines_density";
    private static final String SONARQUBE_TECHNICAL_DEBT = "sqale_index";
    private static final String SONARQUBE_TECHNICAL_DEBT_RATIO = "sqale_debt_ratio";
    private static final short DEFAULT_MAX_RETRY_COUNT = 10;
    private static final int DEFAULT_RETRY_SLEEP = 5000;
    private static final String SONARQUBE_DEFAULT_BUILD_REPORT_NAME = "report-task.txt";
    private static final String PROJECT_KEY_PATTERN_IN_REPORT = "projectKey=(.*)";
    private static final String URL_PATTERN_IN_REPORT = "serverUrl=(.*)";
    private static final String TASK_ID_PATTERN_IN_REPORT = "ceTaskId=(.*)";
    private static final String TASK_URL_PATTERN_IN_REPORT = "ceTaskUrl=(.*)";
    private static final String URL_PATTERN_IN_LOGS_ANALYSIS = ".*" + Pattern.quote("ANALYSIS SUCCESSFUL, you can browse ") + "(.*)";
    private static final String TASK_URL_PATTERN_IN_LOGS = ".*" + Pattern.quote("More about the report processing at ") + "(.*)";
    private static final String PROJECT_NAME_PATTERN_IN_LOGS = ".*" + Pattern.quote("Project key: ") + "(.*)";
    private static final String URL_PATTERN_IN_LOGS_QUALITY_GATE_STATUS = ".*" + Pattern.quote("QUALITY GATE STATUS: ") + "(.*)" + Pattern.quote(" - View details on ") + "(.*)";
    private static final String URL_PATTERN_IN_LOGS_QUALITY_GATE_STATUS_v4_8 = ".*" + Pattern.quote("ANALYSIS SUCCESSFUL, you can find the results at: ") + "(.*)";
    private static final String URL_PATTERN_IN_LOGS_QUALITY_GATE_STATUS_TIMEOUT = ".*" + Pattern.quote("Quality Gate check timeout exceeded - View details on ") + "(.*)";
    private static final String SONAR_ISSUES_BASE_URL = "/api/issues/search?ps=1";
    private static final String SONAR_METRICS_BASE_URL = "/api/measures/component?componentKey=%s&component=%s";
    private static final String SONAR_METRICS_BASE_METRIC = "&metricKeys=";
    private static final OkHttpClient httpClient = new OkHttpClient();
    private static final String BRANCH_NAME_BASE_URL = "&branch=";
    private final String customPrefix;
    private final TaskListener listener;
    private String projectKey = null;
    private String sonarBuildURL = null;
    private String sonarBuildTaskIdUrl = null;
    private String sonarBuildTaskId = null;
    private String sonarIssuesUrl;
    private String sonarMetricsUrl;
    private String token = null;
    private EnvVars env;

    public SonarQubePointGenerator(Run<?, ?> build, TaskListener listener, ProjectNameRenderer projectNameRenderer, long timestamp, String jenkinsEnvParameterTag, String customPrefix, EnvVars env) {
        super(build, listener, projectNameRenderer, timestamp, jenkinsEnvParameterTag);
        this.customPrefix = customPrefix;
        this.listener = listener;
        this.env = env;
    }

    public String getProjectKey() {
        return this.projectKey;
    }

    public String getSonarBuildURL() {
        return this.sonarBuildURL;
    }

    public String getSonarBuildTaskIdUrl() {
        return this.sonarBuildTaskIdUrl;
    }

    public String getSonarBuildTaskId() {
        return this.sonarBuildTaskId;
    }

    @Override
    public boolean hasReport() {
        String[] result = null;
        try {
            result = this.getSonarProjectFromBuildReport();
            this.projectKey = result[0];
            this.sonarBuildURL = result[1];
            this.sonarBuildTaskId = result[2];
            this.sonarBuildTaskIdUrl = result[3];
            return !StringUtils.isEmpty((CharSequence)this.sonarBuildURL);
        }
        catch (IOException | UncheckedIOException | IndexOutOfBoundsException exception) {
            try {
                result = this.getSonarProjectFromBuildLog(this.build);
                if (!StringUtils.isEmpty((CharSequence)result[1])) {
                    this.projectKey = result[0];
                    this.sonarBuildURL = result[1];
                    this.sonarBuildTaskId = result[2];
                    this.sonarBuildTaskIdUrl = result[3];
                    return !StringUtils.isEmpty((CharSequence)this.sonarBuildURL);
                }
            }
            catch (IOException | UncheckedIOException | IndexOutOfBoundsException exception2) {
                // empty catch block
            }
            return false;
        }
    }

    public void setEnv(EnvVars env) {
        this.env = env;
    }

    private void waitForQualityGateTask() throws IOException {
        String logMessage;
        String status;
        int count = 0;
        int MAX_RETRY_COUNT = 10;
        String max_retry = (String)this.env.get((Object)"SONAR_TASK_MAX_RETRY_COUNT");
        if (max_retry != null && !max_retry.isEmpty()) {
            try {
                MAX_RETRY_COUNT = Integer.parseInt(max_retry);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        do {
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            String output = this.getResult(this.sonarBuildTaskIdUrl);
            JSONObject taskObjects = JSONObject.fromObject((Object)output);
            status = taskObjects.getJSONObject("task").getString("status").toUpperCase();
            ++count;
            if (status.equals("FAILED") || status.equals("CANCELED")) {
                logMessage = "[InfluxDB Plugin] Warning: SonarQube task " + this.sonarBuildTaskId + " failed. Status is " + status + "! Getting the QG metrics from the latest completed task!";
                this.listener.getLogger().println(logMessage);
                break;
            }
            logMessage = "[InfluxDB Plugin] INFO: SonarQube task " + this.sonarBuildTaskId + " status is " + status;
            this.listener.getLogger().println(logMessage);
        } while (!status.equals("SUCCESS") && count <= MAX_RETRY_COUNT);
        if (!status.equals("SUCCESS") && count > MAX_RETRY_COUNT) {
            logMessage = "[InfluxDB Plugin] WARNING: Timeout! SonarQube task " + this.sonarBuildTaskId + " is still in progress. Getting the QG metrics from the latest completed task!";
            this.listener.getLogger().println(logMessage);
        }
    }

    private void setSonarDetails(String sonarBuildURL) {
        String sonarServer = this.env.get("SONAR_HOST_URL", sonarBuildURL);
        this.listener.getLogger().println("[InfluxDB Plugin] INFO: Using SonarQube host URL: " + sonarServer);
        Object branchName = this.env.get("SONAR_BRANCH_NAME", "");
        if (!((String)branchName).isEmpty()) {
            this.listener.getLogger().println("[InfluxDB Plugin] INFO: Using SonarQube branch: " + (String)branchName);
            branchName = BRANCH_NAME_BASE_URL + (String)branchName;
        }
        this.sonarIssuesUrl = sonarServer + SONAR_ISSUES_BASE_URL + (String)branchName + "&componentKeys=" + this.projectKey + "&resolved=false&severities=";
        this.sonarMetricsUrl = sonarServer + String.format(SONAR_METRICS_BASE_URL, this.projectKey, this.projectKey) + (String)branchName;
        this.token = (String)this.env.get((Object)"SONAR_AUTH_TOKEN");
        if (this.token != null) {
            String logMessage = "[InfluxDB Plugin] INFO: Using SonarQube auth token found in environment variable SONAR_AUTH_TOKEN";
            this.listener.getLogger().println(logMessage);
        } else {
            String logMessage = "[InfluxDB Plugin] WARNING: No SonarQube auth token found in environment variable SONAR_AUTH_TOKEN. Depending on access rights, this might result in a HTTP/401.";
            this.listener.getLogger().println(logMessage);
        }
    }

    @Override
    public AbstractPoint[] generate() {
        this.setSonarDetails(this.sonarBuildURL);
        AbstractPoint point = null;
        try {
            if (this.sonarBuildTaskId != null) {
                this.waitForQualityGateTask();
            }
            point = this.buildPoint("sonarqube_data", this.customPrefix, this.build).addField(BUILD_DISPLAY_NAME, this.build.getDisplayName()).addField(SONARQUBE_CRITICAL_ISSUES, this.getSonarIssues(this.sonarIssuesUrl, "CRITICAL")).addField(SONARQUBE_BLOCKER_ISSUES, this.getSonarIssues(this.sonarIssuesUrl, "BLOCKER")).addField(SONARQUBE_MAJOR_ISSUES, this.getSonarIssues(this.sonarIssuesUrl, "MAJOR")).addField(SONARQUBE_MINOR_ISSUES, this.getSonarIssues(this.sonarIssuesUrl, "MINOR")).addField(SONARQUBE_INFO_ISSUES, this.getSonarIssues(this.sonarIssuesUrl, "INFO")).addField(SONARQUBE_LINES_OF_CODE, this.getSonarMetric(this.sonarMetricsUrl, "ncloc")).addField(SONARQUBE_CODE_SMELLS, this.getSonarMetric(this.sonarMetricsUrl, SONARQUBE_CODE_SMELLS)).addField(SONARQUBE_BUGS, this.getSonarMetric(this.sonarMetricsUrl, SONARQUBE_BUGS)).addField(SONARQUBE_COVERAGE, this.getSonarMetric(this.sonarMetricsUrl, SONARQUBE_COVERAGE)).addField(SONARQUBE_VULNERABILITIES, this.getSonarMetric(this.sonarMetricsUrl, SONARQUBE_VULNERABILITIES)).addField(SONARQUBE_BRANCH_COVERAGE, this.getSonarMetric(this.sonarMetricsUrl, SONARQUBE_BRANCH_COVERAGE)).addField(SONARQUBE_LINE_COVERAGE, this.getSonarMetric(this.sonarMetricsUrl, SONARQUBE_LINE_COVERAGE)).addField(SONARQUBE_LINES_TO_COVER, this.getSonarMetric(this.sonarMetricsUrl, SONARQUBE_LINES_TO_COVER)).addField(SONARQUBE_DUPLICATED_LINES_DENSITY, this.getSonarMetric(this.sonarMetricsUrl, SONARQUBE_DUPLICATED_LINES_DENSITY)).addField(SONARQUBE_COMPLEXITY, this.getSonarMetric(this.sonarMetricsUrl, SONARQUBE_COMPLEXITY)).addField(SONARQUBE_ALERT_STATUS, this.getSonarMetricStr(this.sonarMetricsUrl, SONARQUBE_ALERT_STATUS)).addField(SONARQUBE_QUALITY_GATE_DETAILS, this.getSonarMetricStr(this.sonarMetricsUrl, SONARQUBE_QUALITY_GATE_DETAILS)).addField(SONARQUBE_TECHNICAL_DEBT, this.getSonarMetric(this.sonarMetricsUrl, SONARQUBE_TECHNICAL_DEBT)).addField(SONARQUBE_TECHNICAL_DEBT_RATIO, this.getSonarMetric(this.sonarMetricsUrl, SONARQUBE_TECHNICAL_DEBT_RATIO));
        }
        catch (IOException e) {
            String logMessage = "[InfluxDB Plugin] Warning: IOException while fetching SonarQube metrics: " + e.getMessage();
            this.listener.getLogger().println(logMessage);
            e.printStackTrace(this.listener.getLogger());
        }
        return new AbstractPoint[]{point};
    }

    protected String getResult(String url) throws IOException {
        Request.Builder requestBuilder = new Request.Builder().get().url(url).header("Accept", "application/json");
        if (this.token != null) {
            String credential = Credentials.basic((String)this.token, (String)"", (Charset)StandardCharsets.UTF_8);
            requestBuilder.header("Authorization", credential);
        }
        try (Response response = httpClient.newCall(requestBuilder.build()).execute();){
            if (response.code() != 200) {
                throw new RuntimeException("Failed : HTTP error code : " + response.code() + " from URL : " + url);
            }
            ResponseBody body = response.body();
            if (body == null) {
                throw new NullPointerException("Failed : null body from URL : " + url);
            }
            String string = body.string();
            return string;
        }
    }

    private String[] getSonarProjectFromBuildLog(Run<?, ?> build) throws IOException {
        String projName = null;
        String url = null;
        String taskId = null;
        String taskUrl = null;
        try (BufferedReader br = new BufferedReader(build.getLogReader());){
            String line;
            Pattern p_analysis_url = Pattern.compile(URL_PATTERN_IN_LOGS_ANALYSIS);
            Pattern p_qg_url = Pattern.compile(URL_PATTERN_IN_LOGS_QUALITY_GATE_STATUS);
            Pattern p_qg_url_timeout = Pattern.compile(URL_PATTERN_IN_LOGS_QUALITY_GATE_STATUS_TIMEOUT);
            Pattern p_qg_url_v4_8 = Pattern.compile(URL_PATTERN_IN_LOGS_QUALITY_GATE_STATUS_v4_8);
            Pattern p_taskUrl = Pattern.compile(TASK_URL_PATTERN_IN_LOGS);
            Pattern p_projName = Pattern.compile(PROJECT_NAME_PATTERN_IN_LOGS);
            while ((line = br.readLine()) != null) {
                Matcher match = p_projName.matcher(line);
                if (match.matches()) {
                    projName = match.group(1);
                    continue;
                }
                match = p_qg_url.matcher(line);
                if (match.matches()) {
                    url = match.group(2);
                } else {
                    match = p_qg_url_v4_8.matcher(line);
                    if (match.matches()) {
                        url = match.group(1);
                        url = url.substring(0, url.lastIndexOf(47));
                        continue;
                    }
                    match = p_qg_url_timeout.matcher(line);
                    if (match.matches()) {
                        url = match.group(1);
                        continue;
                    }
                    match = p_analysis_url.matcher(line);
                    if (match.matches()) {
                        url = match.group(1);
                        continue;
                    }
                    match = p_taskUrl.matcher(line);
                    if (!match.matches()) continue;
                    taskUrl = match.group(1);
                    taskId = taskUrl.split("=")[1];
                }
                break;
            }
        }
        return new String[]{projName, url, taskId, taskUrl};
    }

    private String[] getSonarProjectFromBuildReport() throws IOException, UncheckedIOException {
        List<Path> reportsPaths;
        String projName = null;
        String url = null;
        String taskId = null;
        String taskUrl = null;
        String workspaceDir = (String)this.env.get((Object)"WORKSPACE");
        List<Path> list = reportsPaths = workspaceDir == null ? null : this.findReportByFileName(workspaceDir);
        if (reportsPaths == null || reportsPaths.size() != 1) {
            return new String[]{null, null, null, null};
        }
        String reportFilePath = reportsPaths.get(0).toFile().getPath();
        try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(reportFilePath), StandardCharsets.UTF_8));){
            String line;
            Pattern p_proj_name = Pattern.compile(PROJECT_KEY_PATTERN_IN_REPORT);
            Pattern p_url = Pattern.compile(URL_PATTERN_IN_REPORT);
            Pattern p_task = Pattern.compile(TASK_ID_PATTERN_IN_REPORT);
            Pattern p_url_task = Pattern.compile(TASK_URL_PATTERN_IN_REPORT);
            while ((line = br.readLine()) != null) {
                Matcher match = p_proj_name.matcher(line);
                if (match.matches()) {
                    projName = match.group(1);
                    continue;
                }
                match = p_url.matcher(line);
                if (match.matches()) {
                    url = match.group(1);
                    continue;
                }
                match = p_task.matcher(line);
                if (match.matches()) {
                    taskId = match.group(1);
                    continue;
                }
                match = p_url_task.matcher(line);
                if (!match.matches()) continue;
                taskUrl = match.group(1);
            }
        }
        return new String[]{projName, url, taskId, taskUrl};
    }

    public List<Path> findReportByFileName(String workspacePath) throws IOException, UncheckedIOException {
        Path path = Paths.get(workspacePath, new String[0]);
        String reportName = this.env.get("SONARQUBE_BUILD_REPORT_NAME", SONARQUBE_DEFAULT_BUILD_REPORT_NAME);
        try (Stream<Path> pathStream = Files.find(path, Integer.MAX_VALUE, (p, basicFileAttributes) -> basicFileAttributes.isRegularFile() && p.endsWith(reportName), new FileVisitOption[0]);){
            List<Path> list = pathStream.collect(Collectors.toList());
            return list;
        }
    }

    public String getSonarMetricStr(String url, String metric) throws IOException {
        return this.getSonarMetricValue(url, metric);
    }

    public Float getSonarMetric(String url, String metric) throws IOException {
        Float value = null;
        try {
            value = Float.valueOf(Float.parseFloat(this.getSonarMetricValue(url, metric)));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return value;
    }

    private String getSonarMetricValue(String url, String metric) throws IOException {
        String value = "";
        String output = this.getResult(url + SONAR_METRICS_BASE_METRIC + metric);
        JSONObject metricsObjects = JSONObject.fromObject((Object)output);
        try {
            JSONArray array = metricsObjects.getJSONObject("component").getJSONArray("measures");
            JSONObject metricsObject = array.getJSONObject(0);
            value = metricsObject.getString("value");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return value;
    }

    private int getSonarIssues(String url, String severity) throws IOException {
        String output = this.getResult(url + severity);
        return JSONObject.fromObject((Object)output).getInt("total");
    }
}

