/*
 * Decompiled with CFR 0.152.
 */
package jenkinsci.plugins.influxdb.global;

import hudson.EnvVars;
import hudson.Extension;
import hudson.model.AbstractProject;
import hudson.model.ItemGroup;
import hudson.model.Job;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.listeners.RunListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import jenkinsci.plugins.influxdb.InfluxDbPublicationService;
import jenkinsci.plugins.influxdb.InfluxDbPublisher;
import jenkinsci.plugins.influxdb.models.Target;
import org.apache.commons.lang3.StringUtils;

@Extension
public class GlobalRunListener
extends RunListener<Run<?, ?>> {
    private static final String VARIABLE_PREFIX = "INFLUXDB_PLUGIN_";

    public void onCompleted(Run<?, ?> build, @Nonnull TaskListener listener) {
        String path = build.getParent().getRelativeNameFrom((ItemGroup)Jenkins.getInstanceOrNull());
        Jenkins jenkins = Jenkins.getInstanceOrNull();
        if (jenkins == null) {
            return;
        }
        List<Target> targets = ((InfluxDbPublisher.DescriptorImpl)jenkins.getDescriptorByType(InfluxDbPublisher.DescriptorImpl.class)).getTargets();
        ArrayList<Target> selectedTargets = new ArrayList<Target>();
        for (Target target : targets) {
            if (!this.isTargetMatchingPath(target, path) || this.isPublicationInBuild(target, build)) continue;
            selectedTargets.add(target);
        }
        if (!selectedTargets.isEmpty()) {
            EnvVars env;
            try {
                env = build.getEnvironment(listener);
            }
            catch (IOException | InterruptedException e) {
                env = new EnvVars();
            }
            InfluxDbPublicationService publicationService = new InfluxDbPublicationService(selectedTargets, (String)env.get((Object)"INFLUXDB_PLUGIN_CUSTOM_PROJECT_NAME"), (String)env.get((Object)"INFLUXDB_PLUGIN_CUSTOM_PREFIX"), null, null, null, null, System.currentTimeMillis() * 1000000L, env.expand((String)env.get((Object)"INFLUXDB_PLUGIN_CUSTOM_FIELDS")), env.expand((String)env.get((Object)"INFLUXDB_PLUGIN_CUSTOM_TAGS")), "jenkins_data");
            publicationService.perform(build, listener, env);
        }
    }

    private boolean isPublicationInBuild(Target target, Run<?, ?> build) {
        InfluxDbPublisher publisher;
        Job parent = build.getParent();
        if (parent instanceof AbstractProject && (publisher = (InfluxDbPublisher)((AbstractProject)parent).getPublishersList().get(InfluxDbPublisher.class)) != null) {
            String buildTarget = publisher.getSelectedTarget();
            return buildTarget != null && StringUtils.equals((CharSequence)buildTarget, (CharSequence)target.getDescription());
        }
        return false;
    }

    private boolean isTargetMatchingPath(@Nonnull Target target, @Nonnull String path) {
        if (target.isGlobalListener()) {
            String pattern = target.getGlobalListenerFilter();
            return StringUtils.isBlank((CharSequence)pattern) || Pattern.matches(pattern, path);
        }
        return false;
    }
}

