/*
 * Decompiled with CFR 0.152.
 */
package jenkinsci.plugins.influxdb.generators;

import com.influxdb.client.write.Point;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.robot.RobotBuildAction;
import hudson.plugins.robot.model.RobotCaseResult;
import hudson.plugins.robot.model.RobotResult;
import hudson.plugins.robot.model.RobotSuiteResult;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import jenkinsci.plugins.influxdb.generators.AbstractPointGenerator;
import jenkinsci.plugins.influxdb.generators.TimeGenerator;
import jenkinsci.plugins.influxdb.renderer.ProjectNameRenderer;

public class RobotFrameworkPointGenerator
extends AbstractPointGenerator {
    private static final String RF_NAME = "rf_name";
    private static final String RF_FAILED = "rf_failed";
    private static final String RF_PASSED = "rf_passed";
    private static final String RF_SKIPPED = "rf_skipped";
    private static final String RF_TOTAL = "rf_total";
    private static final String RF_PASS_PERCENTAGE = "rf_pass_percentage";
    private static final String RF_PASS_PERCENTAGE_TOTAL = "rf_pass_percentage_total";
    private static final String RF_SKIP_PERCENTAGE = "rf_skip_percentage";
    private static final String RF_DURATION = "rf_duration";
    private static final String RF_SUITES = "rf_suites";
    private static final String RF_SUITE_NAME = "rf_suite_name";
    private static final String RF_TESTCASES = "rf_testcases";
    private static final String RF_TAG_NAME = "rf_tag_name";
    private static final String RF_AGE = "rf_age";
    private final String customPrefix;
    private final Map<String, RobotTagResult> tagResults;

    public RobotFrameworkPointGenerator(Run<?, ?> build, TaskListener listener, ProjectNameRenderer projectNameRenderer, long timestamp, String jenkinsEnvParameterTag, String customPrefix) {
        super(build, listener, projectNameRenderer, timestamp, jenkinsEnvParameterTag);
        this.customPrefix = customPrefix;
        this.tagResults = new Hashtable<String, RobotTagResult>();
    }

    @Override
    public boolean hasReport() {
        RobotBuildAction robotBuildAction = (RobotBuildAction)this.build.getAction(RobotBuildAction.class);
        return robotBuildAction != null && robotBuildAction.getResult() != null;
    }

    @Override
    public Point[] generate() {
        RobotBuildAction robotBuildAction = (RobotBuildAction)this.build.getAction(RobotBuildAction.class);
        ArrayList<Point> points = new ArrayList<Point>();
        points.add(this.generateOverviewPoint(robotBuildAction));
        points.addAll(this.generateSubPoints(robotBuildAction.getResult()));
        return points.toArray(new Point[0]);
    }

    private Point generateOverviewPoint(RobotBuildAction robotBuildAction) {
        return this.buildPoint("rf_results", this.customPrefix, this.build).addField(RF_FAILED, robotBuildAction.getResult().getOverallFailed()).addField(RF_PASSED, robotBuildAction.getResult().getOverallPassed()).addField(RF_TOTAL, robotBuildAction.getResult().getOverallTotal()).addField(RF_SKIPPED, robotBuildAction.getResult().getOverallSkipped()).addField(RF_PASS_PERCENTAGE, robotBuildAction.getOverallPassPercentage()).addField(RF_PASS_PERCENTAGE_TOTAL, robotBuildAction.getPassPercentageWithSkipped()).addField(RF_SKIP_PERCENTAGE, robotBuildAction.getResult().getSkipPercentage()).addField(RF_DURATION, robotBuildAction.getResult().getDuration()).addField(RF_SUITES, (long)robotBuildAction.getResult().getAllSuites().size());
    }

    private List<Point> generateSubPoints(RobotResult robotResult) {
        ArrayList<Point> subPoints = new ArrayList<Point>();
        TimeGenerator suiteResultTime = new TimeGenerator(this.timestamp);
        for (RobotSuiteResult suiteResult : robotResult.getAllSuites()) {
            long caseTimeStamp = suiteResultTime.next();
            subPoints.add(this.generateSuitePoint(suiteResult, caseTimeStamp));
            TimeGenerator caseResultTime = new TimeGenerator(caseTimeStamp);
            for (RobotCaseResult caseResult : suiteResult.getAllCases()) {
                Point casePoint = this.generateCasePoint(caseResult, caseResultTime.next());
                if (this.casePointExists(subPoints, casePoint)) continue;
                subPoints.add(casePoint);
            }
        }
        TimeGenerator tagTime = new TimeGenerator(this.timestamp);
        for (Map.Entry<String, RobotTagResult> entry : this.tagResults.entrySet()) {
            subPoints.add(this.generateTagPoint(entry.getValue(), tagTime.next()));
        }
        return subPoints;
    }

    private boolean casePointExists(List<Point> subPoints, Point point) {
        for (Point p : subPoints) {
            try {
                String pointFields;
                String pFields = p.toString().substring(p.toString().indexOf("fields="));
                if (!pFields.equals(pointFields = point.toString().substring(point.toString().indexOf("fields=")))) continue;
                return true;
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            }
        }
        return false;
    }

    private Point generateCasePoint(RobotCaseResult caseResult, long timestamp) {
        Point point = this.buildPoint("testcase_point", this.customPrefix, this.build, timestamp).addTag(RF_NAME, caseResult.getName()).addField(RF_NAME, caseResult.getName()).addField(RF_SUITE_NAME, caseResult.getParent().getName()).addField(RF_FAILED, (long)caseResult.getFailed()).addField(RF_PASSED, (long)caseResult.getPassed()).addField(RF_SKIPPED, (long)caseResult.getSkipped()).addField(RF_DURATION, caseResult.getDuration()).addField(RF_AGE, (long)caseResult.getAge());
        for (String tag : caseResult.getTags()) {
            this.markTagResult(tag, caseResult);
        }
        return point;
    }

    private void markTagResult(String tag, RobotCaseResult caseResult) {
        if (this.tagResults.get(tag) == null) {
            this.tagResults.put(tag, new RobotTagResult(tag));
        }
        RobotTagResult tagResult = this.tagResults.get(tag);
        if (!tagResult.testCases.contains(caseResult.getDuplicateSafeName())) {
            tagResult.failed += caseResult.getFailed();
            tagResult.passed += caseResult.getPassed();
            tagResult.skipped += caseResult.getSkipped();
            tagResult.duration += caseResult.getDuration();
            tagResult.testCases.add(caseResult.getDuplicateSafeName());
        }
    }

    private Point generateTagPoint(RobotTagResult tagResult, long timestamp) {
        return this.buildPoint("tag_point", this.customPrefix, this.build, timestamp).addTag(RF_TAG_NAME, tagResult.name).addField(RF_TAG_NAME, tagResult.name).addField(RF_FAILED, (long)tagResult.failed).addField(RF_PASSED, (long)tagResult.passed).addField(RF_SKIPPED, (long)tagResult.skipped).addField(RF_TOTAL, (long)(tagResult.passed + tagResult.failed)).addField(RF_DURATION, tagResult.duration);
    }

    private Point generateSuitePoint(RobotSuiteResult suiteResult, long timestamp) {
        return this.buildPoint("suite_result", this.customPrefix, this.build, timestamp).addTag(RF_SUITE_NAME, suiteResult.getName()).addField(RF_SUITE_NAME, suiteResult.getName()).addField(RF_TESTCASES, (long)suiteResult.getAllCases().size()).addField(RF_FAILED, (long)suiteResult.getFailed()).addField(RF_PASSED, (long)suiteResult.getPassed()).addField(RF_SKIPPED, (long)suiteResult.getSkipped()).addField(RF_TOTAL, (long)suiteResult.getTotal()).addField(RF_DURATION, suiteResult.getDuration());
    }

    private static final class RobotTagResult {
        private final String name;
        private final List<String> testCases = new ArrayList<String>();
        private int failed = 0;
        private int passed = 0;
        private int skipped = 0;
        private long duration = 0L;

        private RobotTagResult(String name) {
            this.name = name;
        }
    }
}

