/*
 * Decompiled with CFR 0.152.
 */
package jenkinsci.plugins.influxdb.generators;

import com.influxdb.client.domain.WritePrecision;
import com.influxdb.client.write.Point;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.PerfPublisher.PerfPublisherBuildAction;
import hudson.plugins.PerfPublisher.Report.Metric;
import hudson.plugins.PerfPublisher.Report.ReportContainer;
import hudson.plugins.PerfPublisher.Report.Test;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import jenkinsci.plugins.influxdb.generators.AbstractPointGenerator;
import jenkinsci.plugins.influxdb.generators.TimeGenerator;
import jenkinsci.plugins.influxdb.renderer.ProjectNameRenderer;

public class PerfPublisherPointGenerator
extends AbstractPointGenerator {
    private final String customPrefix;
    private final PerfPublisherBuildAction performanceBuildAction;
    private final TimeGenerator timeGenerator;

    public PerfPublisherPointGenerator(Run<?, ?> build, TaskListener listener, ProjectNameRenderer projectNameRenderer, long timestamp, String jenkinsEnvParameterTag, String customPrefix) {
        super(build, listener, projectNameRenderer, timestamp, jenkinsEnvParameterTag);
        this.customPrefix = customPrefix;
        this.performanceBuildAction = (PerfPublisherBuildAction)build.getAction(PerfPublisherBuildAction.class);
        this.timeGenerator = new TimeGenerator(timestamp);
    }

    @Override
    public boolean hasReport() {
        return this.performanceBuildAction != null && this.performanceBuildAction.getReport() != null;
    }

    @Override
    public Point buildPoint(String name, String customPrefix, Run<?, ?> build) {
        return super.buildPoint(name, customPrefix, build).time(Long.valueOf(this.timeGenerator.next()), WritePrecision.NS);
    }

    @Override
    public Point[] generate() {
        ReportContainer reports = this.performanceBuildAction.getReports();
        ArrayList<Point> points = new ArrayList<Point>();
        points.add(this.generateSummaryPoint(reports));
        points.addAll(this.generateMetricsPoints(reports));
        for (Test test : reports.getTests()) {
            points.add(this.generateTestPoint(test));
            points.addAll(this.generateTestMetricsPoints(test));
        }
        return points.toArray(new Point[0]);
    }

    private Point generateSummaryPoint(ReportContainer reports) {
        Point point = this.buildPoint("perfpublisher_summary", this.customPrefix, this.build).addField("number_of_tests", (long)reports.getNumberOfTest()).addField("number_of_executed_tests", (long)reports.getNumberOfExecutedTest()).addField("number_of_not_executed_tests", (long)reports.getNumberOfNotExecutedTest()).addField("number_of_passed_tests", (long)reports.getNumberOfPassedTest()).addField("number_of_failed_tests", (long)reports.getNumberOfFailedTest()).addField("number_of_success_tests", (long)reports.getNumberOfSuccessTests()).addField("number_of_true_false_tests", reports.getNumberOfTrueFalseTest());
        if (reports.getBestCompileTimeTest().isCompileTime()) {
            point.addField("best_compile_time_test_value", reports.getBestCompileTimeTestValue()).addField("best_compile_time_test_name", reports.getBestCompileTimeTestName()).addField("worst_compile_time_test_value", reports.getWorstCompileTimeTestValue()).addField("worst_compile_time_test_name", reports.getWorstCompileTimeTestName()).addField("avg_compile_time", reports.getAverageOfCompileTime());
        }
        if (reports.getBestPerformanceTest().isPerformance()) {
            point.addField("best_performance_test_value", reports.getBestPerformanceTestValue()).addField("best_performance_test_name", reports.getBestPerformanceTestName()).addField("worst_performance_test_value", reports.getWorstPerformanceTestValue()).addField("worst_performance_test_name", reports.getWorstPerformanceTestName()).addField("average_performance", reports.getAverageOfPerformance());
        }
        if (reports.getBestExecutionTimeTest().isExecutionTime()) {
            point.addField("best_execution_time_test_value", reports.getBestExecutionTimeTestValue()).addField("best_execution_time_test_name", reports.getBestExecutionTimeTestName()).addField("worst_execution_time_test_value", reports.getWorstExecutionTimeTestValue()).addField("worst_execution_time_test_name", reports.getWorstExecutionTimeTestName()).addField("avg_execution_time", reports.getAverageOfExecutionTime());
        }
        return point;
    }

    private List<Point> generateMetricsPoints(ReportContainer reports) {
        ArrayList<Point> points = new ArrayList<Point>();
        for (Map.Entry entry : reports.getAverageValuePerMetrics().entrySet()) {
            String metricName = (String)entry.getKey();
            Point point = this.buildPoint("perfpublisher_metric", this.customPrefix, this.build).addField("metric_name", metricName).addField("average", (Number)entry.getValue()).addField("worst", (Number)reports.getWorstValuePerMetrics().get(metricName)).addField("best", (Number)reports.getBestValuePerMetrics().get(metricName));
            points.add(point);
        }
        return points;
    }

    private Point generateTestPoint(Test test) {
        Point point = this.buildPoint("perfpublisher_test", this.customPrefix, this.build).addField("test_name", test.getName()).addTag("test_name", test.getName()).addField("successful", test.isSuccessfull()).addField("executed", test.isExecuted());
        if (test.getMessage() != null) {
            point.addField("message", test.getMessage());
        }
        if (test.isCompileTime()) {
            point.addField("compile_time", test.getCompileTime().getMeasure());
        }
        if (test.isExecutionTime()) {
            point.addField("execution_time", test.getExecutionTime().getMeasure());
        }
        if (test.isPerformance()) {
            point.addField("performance", test.getPerformance().getMeasure());
        }
        return point;
    }

    private List<Point> generateTestMetricsPoints(Test test) {
        ArrayList<Point> points = new ArrayList<Point>();
        for (Map.Entry entry : test.getMetrics().entrySet()) {
            String metricName = (String)entry.getKey();
            Metric metric = (Metric)entry.getValue();
            Point point = this.buildPoint("perfpublisher_test_metric", this.customPrefix, this.build).addField("test_name", test.getName()).addTag("test_name", test.getName()).addField("metric_name", metricName).addField("value", metric.getMeasure()).addField("unit", metric.getUnit()).addField("relevant", metric.isRelevant());
            points.add(point);
        }
        return points;
    }
}

