/*
 * Decompiled with CFR 0.152.
 */
package jenkinsci.plugins.influxdb.generators;

import com.influxdb.client.write.Point;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.jacoco.JacocoBuildAction;
import hudson.plugins.jacoco.model.Coverage;
import jenkinsci.plugins.influxdb.generators.AbstractPointGenerator;
import jenkinsci.plugins.influxdb.renderer.ProjectNameRenderer;

public class JacocoPointGenerator
extends AbstractPointGenerator {
    private static final String JACOCO_CLASS = "jacoco_class";
    private static final String JACOCO_LINE = "jacoco_line";
    private static final String JACOCO_BRANCH = "jacoco_branch";
    private static final String JACOCO_METHOD = "jacoco_method";
    private static final String JACOCO_INSTRUCTION = "jacoco_instruction";
    private static final String JACOCO_COMPLEXITY = "jacoco_complexity";
    private final String customPrefix;
    private final JacocoBuildAction jacocoBuildAction;

    public JacocoPointGenerator(Run<?, ?> build, TaskListener listener, ProjectNameRenderer projectNameRenderer, long timestamp, String jenkinsEnvParameterTag, String customPrefix) {
        super(build, listener, projectNameRenderer, timestamp, jenkinsEnvParameterTag);
        this.customPrefix = customPrefix;
        this.jacocoBuildAction = (JacocoBuildAction)build.getAction(JacocoBuildAction.class);
    }

    @Override
    public boolean hasReport() {
        return this.jacocoBuildAction != null && this.jacocoBuildAction.getResult() != null;
    }

    @Override
    public Point[] generate() {
        Point point = this.buildPoint("jacoco_data", this.customPrefix, this.build);
        this.addFields(point, JACOCO_CLASS, this.jacocoBuildAction.getResult().getClassCoverage());
        this.addFields(point, JACOCO_LINE, this.jacocoBuildAction.getResult().getLineCoverage());
        this.addFields(point, JACOCO_BRANCH, this.jacocoBuildAction.getResult().getBranchCoverage());
        this.addFields(point, JACOCO_METHOD, this.jacocoBuildAction.getResult().getMethodCoverage());
        this.addFields(point, JACOCO_INSTRUCTION, this.jacocoBuildAction.getResult().getInstructionCoverage());
        this.addFields(point, JACOCO_COMPLEXITY, this.jacocoBuildAction.getResult().getComplexityScore());
        return new Point[]{point};
    }

    private void addFields(Point point, String prefix, Coverage coverage) {
        point.addField(prefix + "_coverage_rate", (double)coverage.getPercentageFloat());
        point.addField(prefix + "_covered", (long)coverage.getCovered());
        point.addField(prefix + "_missed", (long)coverage.getMissed());
    }
}

