/*
 * Decompiled with CFR 0.152.
 */
package jenkinsci.plugins.influxdb.generators;

import com.influxdb.client.write.Point;
import hudson.EnvVars;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.junit.CaseResult;
import hudson.tasks.test.AbstractTestResultAction;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import jenkinsci.plugins.influxdb.generators.AbstractPointGenerator;
import jenkinsci.plugins.influxdb.renderer.ProjectNameRenderer;
import org.apache.commons.collections.iterators.ReverseListIterator;
import org.apache.commons.lang.StringUtils;

public class JUnitPointGenerator
extends AbstractPointGenerator {
    private static final String JUNIT_SUITE_NAME = "suite_name";
    private static final String JUNIT_TEST_NAME = "test_name";
    private static final String JUNIT_TEST_CLASS_FULL_NAME = "test_class_full_name";
    private static final String JUNIT_PIPELINE_STEP = "pipeline_step";
    private static final String JUNIT_TEST_STATUS = "test_status";
    private static final String JUNIT_TEST_STATUS_ORDINAL = "test_status_ordinal";
    private static final String JUNIT_DURATION = "test_duration";
    private static final String JUNIT_COUNT = "test_count";
    private final String customPrefix;
    private final TaskListener listener;
    private final EnvVars env;

    public JUnitPointGenerator(Run<?, ?> build, TaskListener listener, ProjectNameRenderer projectNameRenderer, long timestamp, String jenkinsEnvParameterTag, String customPrefix, EnvVars env) {
        super(build, listener, projectNameRenderer, timestamp, jenkinsEnvParameterTag);
        this.customPrefix = customPrefix;
        this.listener = listener;
        this.env = env;
    }

    @Override
    public boolean hasReport() {
        return Boolean.parseBoolean((String)this.env.getOrDefault((Object)"LOG_JUNIT_RESULTS", (Object)"false")) && this.hasTestResults(this.build);
    }

    @Override
    public Point[] generate() {
        ArrayList<Point> points = new ArrayList<Point>();
        List<CaseResult> allTestResults = this.getAllTestResults(this.build);
        for (CaseResult caseResult : allTestResults) {
            Point point = this.buildPoint("junit_data", this.customPrefix, this.build).addField(JUNIT_SUITE_NAME, caseResult.getSuiteResult().getName()).addField(JUNIT_TEST_NAME, caseResult.getName()).addField(JUNIT_TEST_CLASS_FULL_NAME, caseResult.getClassName()).addField(JUNIT_PIPELINE_STEP, this.getCaseResultEnclosingFlowNodeString(caseResult)).addField(JUNIT_TEST_STATUS, caseResult.getStatus().toString()).addField(JUNIT_TEST_STATUS_ORDINAL, (long)caseResult.getStatus().ordinal()).addField(JUNIT_DURATION, (double)caseResult.getDuration()).addField(JUNIT_COUNT, 1L).addTag(JUNIT_SUITE_NAME, caseResult.getSuiteResult().getName()).addTag(JUNIT_TEST_NAME, caseResult.getName()).addTag(JUNIT_TEST_CLASS_FULL_NAME, caseResult.getClassName()).addTag(JUNIT_PIPELINE_STEP, this.getCaseResultEnclosingFlowNodeString(caseResult)).addTag(JUNIT_TEST_STATUS, caseResult.getStatus().toString());
            points.add(point);
        }
        return points.toArray(new Point[0]);
    }

    private String getCaseResultEnclosingFlowNodeString(CaseResult caseResult) {
        if (!caseResult.getEnclosingFlowNodeNames().isEmpty()) {
            return StringUtils.join((Iterator)new ReverseListIterator(caseResult.getEnclosingFlowNodeNames()), (String)" / ");
        }
        return "";
    }

    private List<CaseResult> getAllTestResults(Run<?, ?> build) {
        AbstractTestResultAction testResultAction = (AbstractTestResultAction)build.getAction(AbstractTestResultAction.class);
        ArrayList<CaseResult> allTestResults = new ArrayList<CaseResult>();
        allTestResults.addAll(testResultAction.getFailedTests());
        allTestResults.addAll(testResultAction.getSkippedTests());
        allTestResults.addAll(testResultAction.getPassedTests());
        return allTestResults;
    }

    private boolean hasTestResults(Run<?, ?> build) {
        return build.getAction(AbstractTestResultAction.class) != null;
    }
}

