/*
 * Decompiled with CFR 0.152.
 */
package jenkinsci.plugins.influxdb.generators;

import com.influxdb.client.write.Point;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.util.ArrayList;
import java.util.Map;
import jenkinsci.plugins.influxdb.generators.AbstractPointGenerator;
import jenkinsci.plugins.influxdb.renderer.ProjectNameRenderer;

public class CustomDataMapPointGenerator
extends AbstractPointGenerator {
    private final String customPrefix;
    private final Map<String, Map<String, Object>> customDataMap;
    private final Map<String, Map<String, String>> customDataMapTags;

    public CustomDataMapPointGenerator(Run<?, ?> build, TaskListener listener, ProjectNameRenderer projectNameRenderer, long timestamp, String jenkinsEnvParameterTag, String customPrefix, Map<String, Map<String, Object>> customDataMap, Map<String, Map<String, String>> customDataMapTags) {
        super(build, listener, projectNameRenderer, timestamp, jenkinsEnvParameterTag);
        this.customPrefix = customPrefix;
        this.customDataMap = customDataMap;
        this.customDataMapTags = customDataMapTags;
    }

    @Override
    public boolean hasReport() {
        return this.customDataMap != null && this.customDataMap.size() > 0;
    }

    @Override
    public Point[] generate() {
        ArrayList<Point> points = new ArrayList<Point>();
        for (Map.Entry<String, Map<String, Object>> entry : this.customDataMap.entrySet()) {
            Map<String, String> customTags;
            Point point = this.buildPoint(entry.getKey(), this.customPrefix, this.build).addFields(entry.getValue());
            if (this.customDataMapTags != null && (customTags = this.customDataMapTags.get(entry.getKey())) != null && customTags.size() > 0) {
                point.addTags(customTags);
            }
            points.add(point);
        }
        return points.toArray(new Point[0]);
    }
}

