/*
 * Decompiled with CFR 0.152.
 */
package jenkinsci.plugins.influxdb.generators;

import com.influxdb.client.write.Point;
import hudson.model.AbstractBuild;
import hudson.model.Node;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.labels.LabelAtom;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import jenkinsci.plugins.influxdb.generators.AbstractPointGenerator;
import jenkinsci.plugins.influxdb.renderer.ProjectNameRenderer;
import org.apache.commons.collections.CollectionUtils;
import org.jenkinsci.plugins.workflow.actions.WorkspaceAction;
import org.jenkinsci.plugins.workflow.flow.FlowExecution;
import org.jenkinsci.plugins.workflow.flow.FlowExecutionOwner;
import org.jenkinsci.plugins.workflow.graph.FlowGraphWalker;
import org.jenkinsci.plugins.workflow.graph.FlowNode;

public class AgentPointGenerator
extends AbstractPointGenerator {
    protected static final String AGENT_NAME = "agent_name";
    protected static final String AGENT_LABEL = "agent_label";
    protected static final String UNIQUE_ID = "unique_id";
    private List<Map.Entry<String, String>> agentPoints;
    private String customPrefix;

    public AgentPointGenerator(Run<?, ?> build, TaskListener listener, ProjectNameRenderer projectNameRenderer, long timestamp, String jenkinsEnvParameterTag, String customPrefix) {
        super(build, listener, projectNameRenderer, timestamp, jenkinsEnvParameterTag);
        this.agentPoints = this.getAgentPoints(build);
        this.customPrefix = customPrefix;
    }

    @Override
    public boolean hasReport() {
        return CollectionUtils.isNotEmpty(this.agentPoints);
    }

    @Override
    public Point[] generate() {
        ArrayList<Point> points = new ArrayList<Point>();
        Map.Entry<String, String> agentPoint = null;
        for (int i = 0; i < this.agentPoints.size(); ++i) {
            agentPoint = this.agentPoints.get(i);
            Point point = this.buildPoint("agent_data", this.customPrefix, this.build).addTag(UNIQUE_ID, String.valueOf(i + 1)).addField(AGENT_NAME, agentPoint.getKey()).addField(AGENT_LABEL, agentPoint.getValue());
            points.add(point);
        }
        return points.toArray(new Point[0]);
    }

    public String getFirstAgent() {
        return !CollectionUtils.isEmpty(this.agentPoints) ? this.agentPoints.get(0).getKey() : "";
    }

    private List<Map.Entry<String, String>> getAgentPoints(Run<?, ?> build) {
        if (build instanceof AbstractBuild) {
            return this.getAgentFromAbstractBuild((AbstractBuild)build);
        }
        if (build instanceof FlowExecutionOwner.Executable) {
            return this.getAgentsFromPipeline((FlowExecutionOwner.Executable)build);
        }
        return new ArrayList<Map.Entry<String, String>>();
    }

    private List<Map.Entry<String, String>> getAgentFromAbstractBuild(AbstractBuild<?, ?> build) {
        ArrayList<Map.Entry<String, String>> agentPointsList = new ArrayList<Map.Entry<String, String>>();
        Node node = build.getBuiltOn();
        if (node != null) {
            agentPointsList.add(new AbstractMap.SimpleEntry<String, String>(node.getDisplayName(), node.getLabelString()));
        }
        return agentPointsList;
    }

    private List<Map.Entry<String, String>> getAgentsFromPipeline(FlowExecutionOwner.Executable build) {
        FlowExecution flowExecution;
        ArrayList<Map.Entry<String, String>> agentPointsList = new ArrayList<Map.Entry<String, String>>();
        FlowExecutionOwner flowExecutionOwner = build.asFlowExecutionOwner();
        if (flowExecutionOwner != null && (flowExecution = flowExecutionOwner.getOrNull()) != null) {
            FlowGraphWalker graphWalker = new FlowGraphWalker(flowExecution);
            for (FlowNode flowNode : graphWalker) {
                WorkspaceAction workspaceAction = (WorkspaceAction)flowNode.getAction(WorkspaceAction.class);
                if (null == workspaceAction) continue;
                Set labels = workspaceAction.getLabels();
                StringJoiner labelString = new StringJoiner(", ");
                labelString.setEmptyValue("");
                for (LabelAtom label : labels) {
                    labelString.add(label.getName());
                }
                String nodeName = workspaceAction.getNode();
                agentPointsList.add(new AbstractMap.SimpleEntry<String, String>(nodeName, labelString.toString()));
            }
        }
        return agentPointsList;
    }
}

