/*
 * Decompiled with CFR 0.152.
 */
package jenkinsci.plugins.influxdb;

import hudson.Extension;
import hudson.ExtensionList;
import hudson.init.InitMilestone;
import hudson.init.Initializer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import jenkins.model.GlobalConfiguration;
import jenkinsci.plugins.influxdb.InfluxDbPublisher;
import jenkinsci.plugins.influxdb.models.Target;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.StaplerRequest2;

@Extension
public class InfluxDbGlobalConfig
extends GlobalConfiguration {
    private List<Target> targets = new CopyOnWriteArrayList<Target>();
    private boolean targetsMigrated = false;

    public InfluxDbGlobalConfig() {
        this.load();
    }

    public static InfluxDbGlobalConfig getInstance() {
        return (InfluxDbGlobalConfig)((Object)GlobalConfiguration.all().get(InfluxDbGlobalConfig.class));
    }

    public List<Target> getTargets() {
        return Collections.unmodifiableList(this.targets);
    }

    public void setTargets(List<Target> targets) {
        this.targets = targets;
        this.save();
    }

    @Initializer(after=InitMilestone.JOB_LOADED)
    public void migrateTargets() {
        if (this.targetsMigrated) {
            return;
        }
        Optional<InfluxDbPublisher.DescriptorImpl> optionalDescriptor = ExtensionList.lookup(InfluxDbPublisher.DescriptorImpl.class).stream().findFirst();
        optionalDescriptor.ifPresent(publisher -> {
            if (publisher.getDeprecatedTargets().length > 0) {
                this.targets = Arrays.asList(publisher.getDeprecatedTargets());
                this.save();
            }
            publisher.removeDeprecatedTargets();
        });
        this.targetsMigrated = true;
        this.save();
    }

    public boolean configure(StaplerRequest2 req, JSONObject formData) {
        this.targets = new CopyOnWriteArrayList<Target>();
        this.targets.addAll(req.bindJSONToList(Target.class, formData.get("targets")));
        this.save();
        return true;
    }

    public void addTarget(Target target) {
        this.targets.add(target);
    }

    public void removeTarget(String targetDescription) {
        this.targets.removeIf(target -> target.getDescription().equals(targetDescription));
    }
}

