/*
 * Decompiled with CFR 0.152.
 */
package com.google.jenkins.plugins.util;

import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClientRequest;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.jenkins.plugins.util.Executor;
import com.google.jenkins.plugins.util.ExecutorException;
import com.google.jenkins.plugins.util.RequestCallable;
import java.io.IOException;
import java.util.LinkedList;

public class MockExecutor
extends Executor {
    private final LinkedList<Class<?>> requestTypes = new LinkedList();
    private final LinkedList<Object> responses = new LinkedList();
    private final LinkedList<Exception> exceptions = new LinkedList();
    private final LinkedList<Predicate<?>> predicates = new LinkedList();
    private boolean sawUnexpected = false;

    @Override
    public void sleep() {
    }

    @Override
    public <T> T execute(RequestCallable<T> request) throws IOException, ExecutorException {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T execute(AbstractGoogleJsonClientRequest<T> request) throws IOException, ExecutorException {
        Class<?> requestClass = request.getClass();
        if (this.requestTypes.isEmpty()) {
            this.sawUnexpected = true;
            throw new IllegalStateException("Unexpected request: " + String.valueOf(requestClass));
        }
        Class<?> clazz = this.requestTypes.removeFirst();
        Object response = this.responses.removeFirst();
        Exception exception = this.exceptions.removeFirst();
        Predicate<?> predicate = this.predicates.removeFirst();
        if (requestClass != clazz) {
            this.sawUnexpected = true;
            throw new IllegalStateException("Unexpected (or out of order) request: " + String.valueOf(requestClass) + " expected: " + String.valueOf(clazz));
        }
        if (!predicate.apply(request)) {
            this.sawUnexpected = true;
            throw new IllegalStateException("User predicate: " + String.valueOf(predicate) + " failed for request: " + String.valueOf(requestClass));
        }
        if (response == null) {
            if (exception != null) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw (ExecutorException)exception;
            }
            return (T)request.getJsonContent();
        }
        return (T)response;
    }

    public <T, S extends AbstractGoogleJsonClientRequest<T>, C extends S> void when(Class<C> requestType, T response, Predicate<S> predicate) {
        this.requestTypes.add((Class)Preconditions.checkNotNull(requestType));
        this.responses.add(response);
        this.exceptions.add(null);
        this.predicates.add((Predicate)Preconditions.checkNotNull(predicate));
    }

    public <T, C extends AbstractGoogleJsonClientRequest<T>> void when(Class<C> requestType, T response) {
        this.when(requestType, response, Predicates.alwaysTrue());
    }

    public <T, S extends AbstractGoogleJsonClientRequest<T>, C extends S> void throwWhen(Class<C> requestType, IOException exception, Predicate<S> predicate) {
        this.throwWhenInternal(requestType, exception, predicate);
    }

    public <T, C extends AbstractGoogleJsonClientRequest<T>> void throwWhen(Class<C> requestType, IOException exception) {
        this.throwWhen(requestType, exception, Predicates.alwaysTrue());
    }

    public <T, S extends AbstractGoogleJsonClientRequest<T>, C extends S> void throwWhen(Class<C> requestType, ExecutorException exception, Predicate<S> predicate) {
        this.throwWhenInternal(requestType, exception, predicate);
    }

    public <T, C extends AbstractGoogleJsonClientRequest<T>> void throwWhen(Class<C> requestType, ExecutorException exception) {
        this.throwWhen(requestType, exception, Predicates.alwaysTrue());
    }

    private <T, S extends AbstractGoogleJsonClientRequest<T>, C extends S> void throwWhenInternal(Class<C> requestType, Exception exception, Predicate<S> predicate) {
        this.requestTypes.add((Class)Preconditions.checkNotNull(requestType));
        this.responses.add(null);
        this.exceptions.add(exception);
        this.predicates.add((Predicate)Preconditions.checkNotNull(predicate));
    }

    public <T, S extends AbstractGoogleJsonClientRequest<T>, C extends S> void passThruWhen(Class<C> requestType, Predicate<S> predicate) {
        this.requestTypes.add((Class)Preconditions.checkNotNull(requestType));
        this.responses.add(null);
        this.exceptions.add(null);
        this.predicates.add((Predicate)Preconditions.checkNotNull(predicate));
    }

    public <T, C extends AbstractGoogleJsonClientRequest<T>> void passThruWhen(Class<C> requestType) {
        this.passThruWhen(requestType, Predicates.alwaysTrue());
    }

    public boolean sawAll() {
        return this.requestTypes.isEmpty();
    }

    public boolean sawUnexpected() {
        return this.sawUnexpected;
    }
}

