/*
 * Decompiled with CFR 0.152.
 */
package com.google.jenkins.plugins.credentials.oauth;

import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsNameProvider;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.impl.BaseStandardCredentials;
import com.google.api.client.auth.oauth2.Credential;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.jenkins.plugins.credentials.domains.DomainRequirementProvider;
import com.google.jenkins.plugins.credentials.oauth.GoogleOAuth2Credentials;
import com.google.jenkins.plugins.credentials.oauth.GoogleOAuth2ScopeRequirement;
import com.google.jenkins.plugins.credentials.oauth.GoogleRobotCredentialsModule;
import com.google.jenkins.plugins.credentials.oauth.Messages;
import com.google.jenkins.plugins.credentials.oauth.RemotableGoogleCredentials;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.model.ItemGroup;
import hudson.security.ACL;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import hudson.util.Secret;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.kohsuke.stapler.QueryParameter;

public abstract class GoogleRobotCredentials
extends BaseStandardCredentials
implements GoogleOAuth2Credentials {
    private final GoogleRobotCredentialsModule module;
    private static final Long MINIMUM_DURATION_SECONDS = 180L;
    private final String projectId;

    @Deprecated
    protected GoogleRobotCredentials(String projectId, GoogleRobotCredentialsModule module) {
        this(CredentialsScope.GLOBAL, "", projectId, module);
    }

    protected GoogleRobotCredentials(@CheckForNull CredentialsScope scope, String id, String projectId, String description, GoogleRobotCredentialsModule module) {
        super(scope, id == null ? "" : id, description);
        this.projectId = (String)Preconditions.checkNotNull((Object)projectId);
        this.module = module != null ? module : this.getDescriptor().getModule();
    }

    @Deprecated
    protected GoogleRobotCredentials(@CheckForNull CredentialsScope scope, String id, String projectId, GoogleRobotCredentialsModule module) {
        this(scope, id, projectId, null, module);
    }

    public GoogleRobotCredentialsModule getModule() {
        return this.module;
    }

    public AbstractGoogleRobotCredentialsDescriptor getDescriptor() {
        return (AbstractGoogleRobotCredentialsDescriptor)Jenkins.get().getDescriptorOrDie(this.getClass());
    }

    public Secret getAccessToken(GoogleOAuth2ScopeRequirement requirement) {
        try {
            Credential credential = this.getGoogleCredential(requirement);
            Long rawExpiration = credential.getExpiresInSeconds();
            if (!(rawExpiration != null && rawExpiration >= MINIMUM_DURATION_SECONDS || credential.refreshToken())) {
                return null;
            }
            return Secret.fromString((String)credential.getAccessToken());
        }
        catch (IOException | GeneralSecurityException e) {
            return null;
        }
    }

    public static CredentialsListBoxModel getCredentialsListBox(Class<?> clazz) {
        GoogleOAuth2ScopeRequirement requirement = (GoogleOAuth2ScopeRequirement)DomainRequirementProvider.of(clazz, GoogleOAuth2ScopeRequirement.class);
        if (requirement == null) {
            throw new IllegalArgumentException(Messages.GoogleRobotCredentials_NoAnnotation(clazz.getSimpleName()));
        }
        CredentialsListBoxModel listBox = new CredentialsListBoxModel(requirement);
        List allGoogleCredentials = CredentialsProvider.lookupCredentials(GoogleRobotCredentials.class, (ItemGroup)Jenkins.get(), (Authentication)ACL.SYSTEM, (List)ImmutableList.of((Object)((Object)requirement)));
        for (GoogleRobotCredentials credentials : allGoogleCredentials) {
            String name = CredentialsNameProvider.name((Credentials)credentials);
            listBox.add(name, credentials.getId());
        }
        return listBox;
    }

    public static GoogleRobotCredentials getById(String id) {
        List allGoogleCredentials = CredentialsProvider.lookupCredentials(GoogleRobotCredentials.class, (ItemGroup)Jenkins.get(), (Authentication)ACL.SYSTEM, Collections.emptyList());
        for (GoogleRobotCredentials credentials : allGoogleCredentials) {
            if (!credentials.getId().equals(id)) continue;
            return credentials;
        }
        return null;
    }

    public GoogleRobotCredentials forRemote(GoogleOAuth2ScopeRequirement requirement) throws GeneralSecurityException {
        if (this instanceof RemotableGoogleCredentials) {
            return this;
        }
        return new RemotableGoogleCredentials(this, requirement, this.getModule());
    }

    public String getProjectId() {
        return this.projectId;
    }

    protected static abstract class AbstractGoogleRobotCredentialsDescriptor
    extends BaseStandardCredentials.BaseStandardCredentialsDescriptor {
        private final GoogleRobotCredentialsModule module;
        private static final long serialVersionUID = 1L;

        protected AbstractGoogleRobotCredentialsDescriptor(Class<? extends GoogleRobotCredentials> clazz, GoogleRobotCredentialsModule module) {
            super(clazz);
            this.module = (GoogleRobotCredentialsModule)Preconditions.checkNotNull((Object)module);
        }

        protected AbstractGoogleRobotCredentialsDescriptor(Class<? extends GoogleRobotCredentials> clazz) {
            this(clazz, new GoogleRobotCredentialsModule());
        }

        public GoogleRobotCredentialsModule getModule() {
            return this.module;
        }

        public FormValidation doCheckProjectId(@QueryParameter String projectId) {
            if (!Strings.isNullOrEmpty((String)projectId)) {
                return FormValidation.ok();
            }
            return FormValidation.error((String)Messages.GoogleRobotMetadataCredentials_ProjectIDError());
        }
    }

    public static class CredentialsListBoxModel
    extends ListBoxModel {
        private final GoogleOAuth2ScopeRequirement requirement;

        public CredentialsListBoxModel(GoogleOAuth2ScopeRequirement requirement) {
            this.requirement = requirement;
        }

        public Iterable<String> getScopes() {
            return this.requirement.getScopes();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            CredentialsListBoxModel options = (CredentialsListBoxModel)((Object)o);
            return Objects.equals((Object)this.requirement, (Object)options.requirement);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{super.hashCode(), this.requirement});
        }
    }
}

