/*
 * Decompiled with CFR 0.152.
 */
package com.google.jenkins.plugins.metadata;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.jenkins.plugins.metadata.MetadataSerializationException;
import com.google.jenkins.plugins.metadata.MetadataValue;
import hudson.model.Action;
import hudson.model.InvisibleAction;
import hudson.model.Run;
import java.util.Map;

public class MetadataContainer
extends InvisibleAction {
    private final Multimap<String, MetadataValue> metadata = ArrayListMultimap.create();
    private transient java.util.function.Supplier<ObjectMapper> objectMapper;

    public MetadataContainer() {
        this.readResolve();
    }

    private Object readResolve() {
        this.objectMapper = () -> ((Supplier)Suppliers.memoize(ObjectMapper::new)).get();
        return this;
    }

    public Multimap<String, MetadataValue> getMetadata() {
        return Multimaps.unmodifiableMultimap(this.metadata);
    }

    public MetadataContainer add(MetadataValue mv) {
        this.metadata.put((Object)mv.getKey(), (Object)mv);
        return this;
    }

    public <T extends MetadataValue> MetadataContainer addAll(Iterable<T> mvs) {
        for (MetadataValue mv : mvs) {
            this.add(mv);
        }
        return this;
    }

    public void removeAll(String key) {
        this.metadata.removeAll((Object)key);
    }

    public Map<String, String> getSerializedMetadata() {
        return Maps.newHashMap((Map)Maps.transformValues((Map)this.metadata.asMap(), this::listSerialize));
    }

    public static synchronized MetadataContainer of(Run<?, ?> build) {
        MetadataContainer container = (MetadataContainer)build.getAction(MetadataContainer.class);
        if (container == null) {
            container = new MetadataContainer();
            build.addAction((Action)container);
        }
        return container;
    }

    public String serialize(MetadataValue metadataValue) throws MetadataSerializationException {
        return this.listSerialize((Iterable)ImmutableList.of((Object)metadataValue));
    }

    public <T extends MetadataValue> String listSerialize(Iterable<T> values) {
        try {
            return this.getObjectMapper().writerFor((TypeReference)new TypeReference<Iterable<MetadataValue>>(){}).writeValueAsString(values);
        }
        catch (JsonProcessingException ex) {
            throw new MetadataSerializationException(ex);
        }
    }

    public <T extends MetadataValue> T deserialize(Class<T> clazz, String serialized) {
        return (T)((MetadataValue)Iterables.getOnlyElement(this.listDeserialize(clazz, serialized)));
    }

    public <T extends MetadataValue> Iterable<T> listDeserialize(Class<T> clazz, String serialized) {
        try {
            return (Iterable)this.getObjectMapper().readValue(serialized, new TypeReference<Iterable<T>>(){});
        }
        catch (Exception ex) {
            throw new MetadataSerializationException(ex);
        }
    }

    private ObjectMapper getObjectMapper() {
        return this.objectMapper.get();
    }

    public static Multimap<String, MetadataValue> getMetadata(Run<?, ?> build) {
        return MetadataContainer.of(build).getMetadata();
    }
}

